/*
 * printscan.c  -  Print the result of the memory scan
 *
 * Copyright (C) 1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include "romcheck.h"



/*
 * Print the result of the memory scan. First print all signature areas,
 * and then an overview of physical memory in one line.
 */
void printscan(sip)
struct scaninfo *sip;
{
  unsigned short seg, step;
  int i;

  printf("\n\nResults of memory scan:\n\n");

  /* First print result of signature scan */
  step = (ENDSEG - STARTSEG) / sip->romsize;
  for (i = 0; i < sip->signum; i++) {
	printf("%4d      ", i + 1);
	for (seg = STARTSEG; seg < ENDSEG; seg += step) {
		if (seg < sip->sigsegs[i] ||
		    seg >= sip->sigsegs[i] + sip->sigsize[i])
			putchar(CHAR_DASH);
		else if (sip->sigvalid[i])
			putchar(CHAR_VALID);
		else
			putchar(CHAR_INVALID);
	}
	printf("    [%3d kB]\n", sip->sigsize[i] / 64);
  }

  /* Now print the physical memory layout */
  printf("\nPhysical  ");
  for (i = 0; i < sip->romsize; i++) {
	switch (sip->rombuf[i]) {
		case TYPE_RAM:
			putchar(CHAR_RAM);
			break;
		case TYPE_ROM:
			putchar(CHAR_ROM);
			break;
		case TYPE_EMPTY:
			putchar(CHAR_EMPTY);
			break;
		case TYPE_UNKNOWN:
		default:
			putchar(CHAR_UNKNOWN);
			break;
	}
  }

  /* Finally print the arrow pointing to the beginning of the flash memory */
  putchar('\n');
  if (sip->flashseg >= STARTSEG && sip->flashseg < ENDSEG) {
	printf("          ");
	for (seg = STARTSEG; seg < sip->flashseg; seg += step)
		putchar(' ');
	putchar(CHAR_FLASH);
  }
  printf("\nEvery box represents %d kB, starting at segment %4X\n",
			(ENDSEG - STARTSEG) / (sip->romsize * 64), STARTSEG);
}

