/*
 *  nwfstime.c
 *
 *  get/set a file server's time
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 *  Contributors:
 *
 *        Frank A. Vorstenbosch <fav@eidos.co.uk>
 *            Update local time from NetWare server
 *
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>

#include <ncp/ncplib.h>

#include <libintl.h>
#define _(X) gettext(X)

static char *progname;

static void
usage(void)
{
	fprintf(stderr, _("usage: %s [pattern]\n"), progname);
}

static void
help(void)
{
	printf(_("\n"
                 "usage: %s [options]\n"), progname);
	printf(_("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-g             Update local time from file server\n"
	       "-s             Set file server's time from local time\n"
	       "\n"));
}

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	int opt;
	long err;
	int set = 0, get = 0;
	time_t t;
	struct timeval timeval;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	progname = argv[0];

	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("when initializing"));
		return 1;
	}
	while ((opt = getopt(argc, argv, "h?sg")) != EOF)
	{
		switch (opt)
		{
		case 'h':
		case '?':
			help();
			break;
		case 's':
			set = 1;
			break;
		case 'g':
			get = 1;
			break;
		default:
			usage();
			goto finished;
		}
	}

      finished:

	if (set != 0)
	{
		time(&t);
		if ((err = ncp_set_file_server_time(conn, &t)) != 0)
		{
			com_err(argv[0], err, _("when setting file server time"));
			ncp_close(conn);
			return 1;
		}
	} else
	{
		if ((err = ncp_get_file_server_time(conn, &t)) != 0)
		{
			com_err(argv[0], err, _("when getting file server time"));
			ncp_close(conn);
			return 1;
		}
		{
			char text_server_time[200];
			struct tm* tm;
			
			tm = localtime(&t);
			strftime(text_server_time, sizeof(text_server_time), "%c", tm);
			printf("%s\n", text_server_time);
		}
		if (get)
		{
			timeval.tv_sec = t;
			timeval.tv_usec = 500000; /* severely bogus guestimate */
			settimeofday(&timeval, NULL);
		}
	}

	ncp_close(conn);
	return 0;
}
