/**************************************************************************** 
** File: mgcp.c
**
** Author: Cullen Jennings & Mike Borella
**
** Comments: Dump MGCP header information. I didn't try to do anything
** fancy with this - I just dump the plaintext 
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#define LINE_SIZE 256
#define FALSE 0
#define TRUE  1

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** is_mgcp()
**
** Return true if this udp packet is a MGCP packet 
**
**----------------------------------------------------------------------------
*/

int is_mgcp(u_char *bp, int length)
{
   if ( length < 4 ) return 0;

   if ( !strncmp(bp,"EPCF",4) ) return 1;
   if ( !strncmp(bp,"RQNT",4) ) return 1;
   if ( !strncmp(bp,"NTFY",4) ) return 1;
   if ( !strncmp(bp,"CRCX",4) ) return 1;
   if ( !strncmp(bp,"MDCX",4) ) return 1;
   if ( !strncmp(bp,"DLCX",4) ) return 1;
   if ( !strncmp(bp,"AUEP",4) ) return 1;
   if ( !strncmp(bp,"AUCX",4) ) return 1;
   if ( !strncmp(bp,"RSIP",4) ) return 1;

   return 0;
}


/*----------------------------------------------------------------------------
**
** dump_mgcp()
**
** Parse MGCP packet and dump fields. 
**
**----------------------------------------------------------------------------
*/

void dump_mgcp(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  char line[LINE_SIZE];
  int n = 0;
  int get_next_line(u_char *, u_char *, char *);

  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        MGCP \n");
  printf("-----------------------------------------------------------------\n");

  while(p <= ep && (n = get_next_line(p, ep, line)))
    {
      p = p + n;
      length = length - n;

      printf("%s\n", line);
    }
}

