/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998,1999 Bert Vermeulen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define DETAIL_HORIZ_PADDING  5
#define DETAIL_VERT_PADDING  10

struct resultset {
     char dn[MAX_DN_LEN];
     struct oc *objectclass;
     struct attrs *attributes;
     int num_attributes;
     struct resultset *next;
};


void free_resultset(struct resultset *set);
struct resultset *new_resultset(void);
int new_attr(char *attr);
struct attrs *find_attr(char *attr);
int column_by_attr(char *attribute);
void free_cur_attrs(void);
void query(char *querystring);
void results_popup_menu(GdkEventButton *event, struct resultset *set);
void delete_search_entry(struct resultset *set);
int select_entry_callback(GtkWidget *clist, gint row, gint column,
			   GdkEventButton *event, gpointer data);
int unselect_entry_callback(GtkWidget *clist, gint row, gint column,
			   GdkEventButton *event, gpointer data);
