/* new.c - Dialog to let user add or edit entry.

   Copyright (C) 1998 Tom Tromey

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <config.h>

#include <stdlib.h>
#include <string.h>

#include "sync.h"



static void
ok_button (GtkWidget *widget, gpointer client_data)
{
  GtkEntry *local, *remote;
  GtkWidget *dialog;
  struct database *database;
  char *lname, *rname;

  dialog = GTK_WIDGET (client_data);
  database = (struct database *) (gtk_object_get_data (GTK_OBJECT (dialog),
						       "database"));
  local = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (dialog),
					  "local_entry"));
  lname = gtk_entry_get_text (local);
  remote = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (dialog),
					   "remote_entry"));
  rname = gtk_entry_get_text (remote);

  add_display_entry (database, lname, rname);
  update_entry (database->database, lname, rname, CHECKSUM_NEVER);

  gtk_widget_destroy (dialog);

  /* Might as well.  */
  if (database->database->sync (database->database, 0) == -1)
    db_posix_error (_("Error while synchronizing database file"),
		    database->filename);
}

static void
cancel_button (GtkWidget *widget, gpointer client_data)
{
  GtkWidget *dialog = GTK_WIDGET (client_data);
  gtk_widget_destroy (dialog);
}

static void
delete_event (GtkWidget *dialog, GdkEvent *event, gpointer client_data)
{
  gtk_widget_destroy (dialog);
}

/* FIXME: `id' should be const.  */
static GtkWidget *
make_entry (const char *label, GtkWidget **entry_ret, const char *text,
	    char *id)
{
  GtkWidget *hbox, *w;

  hbox = gtk_hbox_new (FALSE, 4);
  gtk_container_border_width (GTK_CONTAINER (hbox), 4);

  w = gtk_label_new (label);
  gtk_box_pack_start (GTK_BOX (hbox), w, FALSE, FALSE, 0);
  gtk_widget_show (w);

  w = gnome_file_entry_new (id, _("Browse..."));
  *entry_ret = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (w));
  gtk_box_pack_start (GTK_BOX (hbox), w, TRUE, TRUE, 0);
  gtk_widget_show (w);
  gtk_entry_set_text (GTK_ENTRY (*entry_ret), text);

  return hbox;
}

static GtkWidget *
create_dialog (struct database *database, const char *local_name,
	       const char *remote_name)
{
  GtkWidget *dialog, *entry, *box;

  dialog = gnome_dialog_new (_("New entry"), GNOME_STOCK_BUTTON_OK,
			     GNOME_STOCK_BUTTON_CANCEL, NULL);
  gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (database->top));

  gtk_object_set_data (GTK_OBJECT (dialog), "database", database);

  gnome_dialog_button_connect (GNOME_DIALOG (dialog), 0,
			       (GtkSignalFunc) ok_button, dialog);
  gnome_dialog_button_connect (GNOME_DIALOG (dialog), 1,
			       (GtkSignalFunc) cancel_button, dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      (GtkSignalFunc) delete_event, NULL);

  gnome_dialog_set_default (GNOME_DIALOG (dialog), 0);

  box = make_entry (_("Local name:"), &entry, local_name, "Local");
  gtk_object_set_data (GTK_OBJECT (dialog), "local_entry", entry);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), box,
		      FALSE, FALSE, 0);
  gtk_widget_show (box);

  box = make_entry (_("Remote name:"), &entry, remote_name, "Remote");
  gtk_object_set_data (GTK_OBJECT (dialog), "remote_entry", entry);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), box,
		      FALSE, FALSE, 0);
  gtk_widget_show (box);

  return dialog;
}

void
new_entry (struct database *database)
{
  GtkWidget *dialog;

  dialog = create_dialog (database, "", "");
  gtk_widget_show (dialog);
}

/* FIXME: this function fails if the user changes the local name.  In
   this case we should remove the old local entry and add a new one.
   Or?  */
void
edit_entry (struct database *database, const char *local_file)
{
  GtkWidget *dialog;
  struct entry *entry;

  entry = lookup (database->database, local_file);
  if (entry == NULL)
    {
      /* FIXME: consistency error.  Should report.  */
      return;
    }

  dialog = create_dialog (database, local_file, entry->name);
  free_entry (entry);

  gtk_widget_show (dialog);
}
