/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/*Includes*/
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

typedef enum _TabType		TabType;
typedef struct _DndWindow	DndWindow;

enum _TabType
{
	DOWNLOAD_TAB,
	UPLOAD_TAB,
	ADVANCED_TAB
};

struct _DndWindow
{
	GtkWidget *window;
	gint	x;
	gint	y;
	gint	width;
	gint	height;
	gint	Dtab_position;
	GtkWidget *Dtab_paned;
	GtkWidget *notebook;


};

/* These are the actual supported flags */
enum {
   paused,
   renamed,
   spooled,
   mirrored,
   overwrite,
};
#define LAST_FLAG 4

/* We could receive drags from Gnome and Netscape */
enum {
   TARGET_URI_LIST,
   TARGET_NETSCAPE_URL,
};

DndWindow *DND;

/* Options, I love options */
gboolean use_flags;		// use Darxite default flags
gboolean use_outputdir;	// use Darxite default output dir
gboolean show_dialog;	// show a dialog if when drops received
gboolean use_clipboard;	// paste the clipboard content when showing the dialog
gboolean not_paused;	// never put paused files in the batch (non interactive)
gboolean show_flash;	// flash something when the drop is accepted
gboolean use_resume;	// always resume files (don't ask the user what to do)
gboolean use_cumulative; // No coded yet :(

int autostart_daemon;

char TargetDir[256]; /*It needs to be initialized to OutputDir at the begining*/

gchar flags[LAST_FLAG]; /* p,r,s,m,b I think... */
gchar default_flags[LAST_FLAG]; /* Default flags taken from ReadConfigFiles */


/* These are the functions to export */

void drag_data_received (GtkWidget *widget, GdkDragContext *context,
   		   gint x, gint y, GtkSelectionData *selection_data,
                   guint info, guint time, gpointer data);

void pop_window_d();
void pop_window_u();
void pop_window_a();
