/*
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#include "setup.h"
#include <stdio.h>
#ifdef HAVE_STRING_H
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif
#include "eventlog.h"
#include "bnethash.h"


int main(int argc, char * argv[])
{
    char   buff[256];
    t_hash hash;
    
    if (argc<1 || !argv || !argv[0])
    {
	fprintf(stderr,"Got bad arguments.\n");
	return 1;
    }
    if (argc>2)
    {
	fprintf(stderr,"usage: %s [<text>]\n",argv[0]);
	return 0;
    }
    eventlog_set(stderr);
    if (argc==1)
    {
	printf("Enter password to hash: ");
	fflush(stdout);
	fgets(buff,256,stdin);
	buff[strlen(buff)-1] = '\0';
	bnet_hash(&hash,strlen(buff),buff);
    }
    else
	bnet_hash(&hash,strlen(argv[1]),argv[1]);
    printf("\"BNET\\\\acct\\\\passhash1\"=\"%s\"\n",hash_get_str((t_hash const *)&hash)); /* avoid warning */
    
    return 0;
}
