/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"
#include <ctype.h>



/*******************************************************************************
Import edit rule button was pressed
**********************************************************************************/
void import_edit_rule()
{
  GtkWidget *dialog;
  GList *list;
  gint tint;
  gchar *tstringp, *tstringp2, *line[1];
  GString *tstring, *tstring2;
  extern GtkWidget *main_window, *import_rules_clist, *import_rule_name, *import_edit_rule_window;
  extern GtkWidget *import_edit_rule_clist;
  extern gchar *mess_nothing_selected;
  extern struct record config;
  
  
  create_import_edit_rule_window();
  list = GTK_CLIST (import_rules_clist)->selection;
  if (list)
  {
	tint = (int) list->data;
  	gtk_clist_get_text (GTK_CLIST (import_rules_clist), tint, 0, &tstringp);  
  	gtk_entry_set_text(GTK_ENTRY(import_rule_name), tstringp);
  	tstring = g_string_new (NULL);
  	tstring2 = g_string_new (NULL);
  	g_string_sprintf (tstring, "/gstalker/Import/%s=", tstringp);
  	tstringp2 = gnome_config_get_string (tstring->str);
  	g_string_assign (tstring, tstringp2);
  	g_free (tstringp2);
  	tint = 0;
  	while (tint == 0)
  	{
  		tstringp = strchr (tstring->str, ',');
  		if (! tstringp)
  		{
  			line[0] = tstring->str;
  			gtk_clist_append (GTK_CLIST (import_edit_rule_clist), line);
  			break;
  		}
  		else
  		{
  			g_string_assign (tstring2, tstring->str);
  			tstringp2 = strchr (tstring2->str, ',');
  			*tstringp2 = 0;
  			line[0] = tstring2->str;
  			gtk_clist_append (GTK_CLIST (import_edit_rule_clist), line);
  			g_string_erase (tstring, 0, strlen (tstring2->str) + 1);
  			g_strstrip (tstring->str);
  		}
  	}
  	g_string_free (tstring, TRUE);
      	g_string_free (tstring2, TRUE);
  }
  else
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
    
  gtk_widget_show (import_edit_rule_window);
  config.import_edit_rule_window_open = 1;
}
/*******************************************************************************
Import new rule button was pressed
**********************************************************************************/
void import_new_rule()
{
  extern GtkWidget *import_edit_rule_window;
  extern struct record config;
  
  
  create_import_edit_rule_window();
  gtk_widget_show (import_edit_rule_window);
  config.import_edit_rule_window_open = 1;
}
/*****************************************************************************
The import rule insert button was pressed.
*****************************************************************************/
void import_rule_field_insert_button ()
{
  gint tint;
  gchar *tstringp;
  GtkWidget *dialog;
  GList *list, *list2=NULL;
  extern GtkWidget *main_window, *import_rule_field_clist, *import_edit_rule_clist;
  extern gchar *mess_nothing_selected;
  
  
  list = GTK_CLIST (import_rule_field_clist)->selection;
  if (! list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
  
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (import_rule_field_clist), tint, 0, &tstringp);
  list2 = GTK_CLIST (import_edit_rule_clist)->selection;
  if (! list2)
  	gtk_clist_append (GTK_CLIST (import_edit_rule_clist), &tstringp);
  else
  {
  	tint = (int) list2->data;
  	gtk_clist_insert (GTK_CLIST (import_edit_rule_clist), tint, &tstringp);
  }
}
/*****************************************************************************
The import rule delete button was pressed.
*****************************************************************************/
void import_rule_field_delete_button ()
{
  gint tint;
  GtkWidget *dialog;
  GList *list;
  extern GtkWidget *main_window, *import_edit_rule_clist;
  extern gchar *mess_nothing_selected;
  
  
  list = GTK_CLIST (import_edit_rule_clist)->selection;
  if (! list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
  
  tint = (int) list->data;
  gtk_clist_remove (GTK_CLIST (import_edit_rule_clist), tint);
}
/******************************************************************************
The cancel button for edit rule window was pressed.
*******************************************************************************/
void import_edit_rule_cancel()
{
  extern GtkWidget *import_edit_rule_window;
  extern struct record config;
  

  gtk_widget_destroy (import_edit_rule_window);
  config.import_edit_rule_window_open = 0;
}
/*******************************************************************************
This pops up the edit rule dialog.
********************************************************************************/
void create_import_edit_rule_window()
{
  gchar *line[1];
  GtkWidget *hbox, *hbox2, *hbox3, *vbox, *vbox2, *frame, *frame2, *ok_button, *cancel_button;
  GtkWidget *swindow, *swindow2, *frame3, *insert_button, *delete_button;
  extern GtkWidget *import_edit_rule_window, *import_rule_name;
  extern GtkWidget *import_edit_rule_clist, *import_rule_field_clist;
  extern struct record config;
  extern gchar *label_edit_rule, *label_rule_name, *label_rule, *label_rule_fields;
  extern gchar *label_ok, *label_delete, *label_insert, *label_cancel, *label_symbol;
  extern gchar *label_date, *label_open, *label_high, *label_low, *label_close, *label_volume;
  extern gchar *label_ointerest, *label_ignore;
  
  

  if (config.import_edit_rule_window_open)
  	return;
  
  import_edit_rule_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (import_edit_rule_window), "destroy",
	    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &import_edit_rule_window);
  gtk_window_position (GTK_WINDOW (import_edit_rule_window), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (import_edit_rule_window), 0);
  gtk_widget_set_usize (GTK_WIDGET (import_edit_rule_window), 0, 0);
  gtk_window_set_title (GTK_WINDOW (import_edit_rule_window), label_edit_rule);
  
  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (import_edit_rule_window), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_widget_show (hbox);

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
  gtk_widget_show (vbox);
  
  vbox2 = gtk_vbutton_box_new ();
  gtk_box_pack_end (GTK_BOX (hbox), vbox2, FALSE, TRUE, 10);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox2);

  frame = gtk_frame_new (label_rule_name);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_widget_show (frame);
  
  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (frame), hbox2);
  gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
  gtk_widget_show (hbox2);
  
  import_rule_name = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (hbox2), import_rule_name, TRUE, TRUE, 0);
  gtk_widget_show(import_rule_name);
  
  hbox3 = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (vbox), hbox3);
  gtk_widget_show (hbox3);
  
  frame2 = gtk_frame_new (label_rule);
  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add (GTK_CONTAINER (frame2), swindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  import_edit_rule_clist = gtk_clist_new (1);
  gtk_clist_set_selection_mode (GTK_CLIST (import_edit_rule_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow), import_edit_rule_clist);
  gtk_container_border_width (GTK_CONTAINER (import_edit_rule_clist), 5);
  gtk_widget_set_usize (GTK_WIDGET (import_edit_rule_clist), 150, 150);
  gtk_widget_show (import_edit_rule_clist);
  
  frame3 = gtk_frame_new (label_rule_fields);
  gtk_box_pack_start (GTK_BOX (hbox3), frame3, TRUE, TRUE, 0);
  gtk_widget_show (frame3);
  
  swindow2 = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add (GTK_CONTAINER (frame3), swindow2);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow2),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow2);

  import_rule_field_clist = gtk_clist_new (1);
  gtk_clist_set_selection_mode (GTK_CLIST (import_rule_field_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow2), import_rule_field_clist);
  gtk_container_border_width (GTK_CONTAINER (import_rule_field_clist), 5);
  gtk_widget_set_usize (GTK_WIDGET (import_rule_field_clist), 150, 150);
  gtk_widget_show (import_rule_field_clist);
  
  ok_button = gtk_button_new_with_label (label_ok);
  gtk_box_pack_start (GTK_BOX (vbox2), ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      GTK_SIGNAL_FUNC (import_save_button), NULL);
  gtk_widget_show (ok_button);
  
  insert_button = gtk_button_new_with_label (label_insert);
  gtk_box_pack_start (GTK_BOX (vbox2), insert_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (insert_button), "clicked",
		      GTK_SIGNAL_FUNC (import_rule_field_insert_button), NULL);
  gtk_widget_show (insert_button);
  
  delete_button = gtk_button_new_with_label (label_delete);
  gtk_box_pack_start (GTK_BOX (vbox2), delete_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (import_rule_field_delete_button), NULL);
  gtk_widget_show (delete_button);
  
  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox2), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (import_edit_rule_cancel), NULL);
  gtk_widget_show (cancel_button);
  
  line[0] = label_symbol;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_date;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_open;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_high;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_low;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_close;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_volume;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_ointerest;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
  line[0] = label_ignore;
  gtk_clist_append (GTK_CLIST (import_rule_field_clist), line);
}
/******************************************************************************/
gint
import_record(GString *rule, gchar *buffer, gchar *passed_symbol, gint line)
{
  gboolean open_flag=FALSE, high_flag=FALSE, low_flag=FALSE, volume_flag=FALSE, oi_flag=FALSE;
  gboolean error_flag=FALSE, rc=FALSE;
  GtkWidget *dialog;
  gint tint, tint2, format_id=1;
  FILE *infile2;
  GString *tstring, *tstring2, *trule, *tdata, *error_msg, *tstring3, *symbol=NULL;
  GString *date, *open, *high, *low, *close, *volume, *ointerest, *name, *data;
  gchar *tstringp;
  extern GString *gstring;
  extern gchar *mess_cant_create_chart;
  extern gchar *label_date, *label_open, *label_high, *label_low, *label_close, *label_volume;
  extern gchar *label_ointerest, *label_ignore, *label_symbol, *label_name, *label_importing;
  extern gchar *mess_invalid_symbol, *mess_invalid_name, *mess_invalid_date;
  extern gchar *mess_invalid_open, *mess_invalid_high, *mess_invalid_low;
  extern gchar *mess_invalid_close, *mess_invalid_volume, *mess_invalid_ointerest;
  extern gchar *label_skipped_line;
  extern struct record config;
  extern GtkWidget *data_bar, *main_window;




  tstring = g_string_new(NULL);
  tstring2 = g_string_new(NULL);
  error_msg = g_string_new(NULL);
  tstring3 = g_string_new(NULL);
  trule = g_string_new(NULL);
  tdata = g_string_new(NULL);
  date = g_string_new(NULL);
  open = g_string_new(NULL);
  high = g_string_new(NULL);
  low = g_string_new(NULL);
  close = g_string_new(NULL);
  volume = g_string_new(NULL);
  ointerest = g_string_new(NULL);
  name = g_string_new(NULL);
  data = g_string_new(NULL);
  symbol = g_string_new(NULL);
    
  g_string_assign(trule, rule->str);
  tint = strlen (buffer);
  for (tint2 = 0; tint2 < tint; tint2++)
  {
  	if (buffer[tint2] == '"')
  		buffer[tint2] = ' ';
  }
  g_strdelimit(buffer, GS_DELIMITERS, ' ');
  g_strstrip(buffer);
  g_string_assign(tdata, buffer);
	
  tint = 0;
  while(tint >= 0)
  {
  	if (strlen(trule->str) > 0)
  	{
		g_string_assign(tstring, trule->str);
  		tstringp = strchr(tstring->str, ',');
  		if (tstringp)
  		{
  			*(tstringp) = 0;
  			g_string_erase(trule, 0, strlen(tstring->str) + 1);
  		}
  		else
  		{
  			g_string_assign (tstring, trule->str);
  			g_string_truncate (trule, 0);
  		}
  	}
  	else
  		break;
  		
  	if (strstr(tstring->str, label_ignore))
  		format_id = 10;
  	else
  	{
		if (strstr(tstring->str, label_symbol))
  			format_id = 1;
  		else
  		{
  			if (strstr(tstring->str, label_name))
  				format_id = 2;
  			else
  			{
  				if (strstr(tstring->str, label_date))
  					format_id = 3;
  				else
  				{
  					if (! strcmp(tstring->str, label_open))
  							format_id = 4;
  					else
  					{
  						if (strstr(tstring->str, label_high))
  							format_id = 5;
  						else
  						{
  							if (strstr(tstring->str, label_low))
  								format_id = 6;
  							else
  							{
  								if (strstr(tstring->str, label_close))
  									format_id = 7;
  								else
  								{
  									if (strstr(tstring->str, label_volume))
  										format_id = 8;
  									else
  									{
  										if (! strcmp(tstring->str, label_ointerest))
  											format_id = 9;
  										else
  											format_id = 0;
  									}
  								}
  							}
  						}
  					}
  				}
  			}
  		}
  	}
  		
  	g_string_assign(tstring, tdata->str);
  	g_strstrip (tstring->str);
  	tstringp = strchr(tstring->str, ' ');
  	if (tstringp)
  	{
  		*(tstringp) = 0;
  		g_string_erase(tdata, 0, strlen(tstring->str) + 1);
  		g_strstrip (tdata->str);
  	}
  		
	switch(format_id)
	{
		case 1: g_string_assign(symbol, tstring->str);
	  			if (import_check_symbol(symbol->str))
	 			{
	  				g_string_assign(error_msg, mess_invalid_symbol);
	  				error_flag = TRUE;
	  			}
	  			break;
	  	case 2: g_string_assign(name, tstring->str);
	  			if (import_check_symbol(name->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_name);
	  				error_flag = TRUE;
	  			}
	  			break;
	  	case 3: g_string_assign(date, tstring->str);
	  			if (import_check_date(date->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_date);
	  				error_flag = TRUE;
	  			}
	  			else
	  				g_string_assign(date, gstring->str);
	  			break;
	  	case 4: g_string_assign(open, tstring->str);
	  			if (import_check_number(open->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_open);
	  				error_flag = TRUE;
	  			}
	  			else
	  			{
	  				g_string_assign(open, gstring->str);
	  				open_flag = TRUE;
	  			}
	  			break;
	  	case 5: g_string_assign(high, tstring->str);
	  			if (import_check_number(high->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_high);
	  				error_flag = TRUE;
	  			}
	  			else
	  			{
	  				g_string_assign(high, gstring->str);
	  				high_flag = TRUE;
	  			}
	  			break;
	  	case 6: g_string_assign(low, tstring->str);
	  			if (import_check_number(low->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_low);
	  				error_flag = TRUE;
	  			}
	  			else
	  			{
	  				g_string_assign(low, gstring->str);
	  				low_flag = TRUE;
	  			}
	  			break;
	  	case 7: g_string_assign(close, tstring->str);
	  			if (import_check_number(close->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_close);
	  				error_flag = TRUE;
	  			}
	  			else
	  				g_string_assign(close, gstring->str);
	  			break;
	  	case 8: g_string_assign(volume, tstring->str);
	  			if (import_check_number(volume->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_volume);
	  				error_flag = TRUE;
	  			}
	  			else
	  				volume_flag = TRUE;
	  			break;
	  	case 9: g_string_assign(ointerest, tstring->str);
	  			if (import_check_number(ointerest->str))
	  			{
	  				g_string_assign(error_msg, mess_invalid_ointerest);
	  				error_flag = TRUE;
	  			}
	  			else
	  				oi_flag = TRUE;
	  			break;
	  	default: break;
	  }
	  tint++;
  }
	  	
  if (! error_flag)
  {
	g_string_assign(data, date->str);
	g_string_append(data, " ");
	      
	if (! open_flag)
		g_string_append(data, "0");
	else
	      	g_string_append(data, open->str);
	g_string_append(data, " ");
	      
	if (! high_flag)
	      	g_string_append(data, "0");
	else
	      	g_string_append(data, high->str);
	g_string_append(data, " ");
	      
	if (! low_flag)
	      	g_string_append(data, "0");
	else
	      	g_string_append(data, low->str);
	g_string_append(data, " ");
	      
	g_string_append(data, close->str);
	g_string_append(data, " ");
	      
	if (! volume_flag)
	      	g_string_append(data, "0");
	else
	      	g_string_append(data, volume->str);
	g_string_append(data, " ");
	      
	if (! oi_flag)
	      	g_string_append(data, "0");
	else
	      	g_string_append(data, ointerest->str);
	      
	g_string_assign(tstring, config.indexpath);
	if (strlen(passed_symbol) > 0)
		g_string_assign (symbol, passed_symbol);
	g_string_append(tstring, symbol->str);
	infile2 = fopen (tstring->str, "r");
	if (infile2)
	{
		fclose (infile2);
		g_string_sprintf (tstring, "%s %s", label_importing, symbol->str);
		gnome_appbar_set_status (GNOME_APPBAR(data_bar), tstring->str);
		insert_chart_record (symbol->str, date->str, data->str);
	}
	else
	{
		tint = create_new_chart (symbol->str);
		if (tint)
		{
			dialog = gnome_app_error (GNOME_APP(main_window), mess_cant_create_chart);
			gtk_widget_show(dialog);
			return TRUE;
		}
		else
		    insert_chart_record (symbol->str, date->str, data->str);
	}
  }
  else
  {
	 rc = TRUE;
	 g_string_sprintf (tstring, "%s %i, %s\n", label_skipped_line, line, error_msg->str);
	 g_string_assign (gstring, tstring->str);
  }
  	
  g_string_free(tstring, TRUE);
  g_string_free(tstring2, TRUE);
  g_string_free(error_msg, TRUE);
  g_string_free(tstring3, TRUE);
  g_string_free(trule, TRUE);
  g_string_free(tdata, TRUE);
  g_string_free(symbol, TRUE);
  g_string_free(date, TRUE);
  g_string_free(open, TRUE);
  g_string_free(high, TRUE);
  g_string_free(low, TRUE);
  g_string_free(close, TRUE);
  g_string_free(volume, TRUE);
  g_string_free(ointerest, TRUE);
  g_string_free(name, TRUE);
  g_string_free(data, TRUE);
  
  return rc;
}
/********************************************************************************/
void
import_ok_check()
{
  GString *tstring;
  GList *list;
  GtkWidget *dialog;
  gchar *tstringp, *tstringp2;
  gint tint;
  extern GtkWidget *import_rules_clist, *import_file_label, *main_window;
  extern gchar *mess_nothing_selected, *mess_nothing_entered, *label_enter_import_symbol;
  
  
  list = GTK_CLIST (import_rules_clist)->selection;
  if (! list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
  
  tstringp = gtk_entry_get_text(GTK_ENTRY(import_file_label));
  if (strlen (tstringp) == 0)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_entered);
	gtk_widget_show(dialog);
	return;
  }
  
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (import_rules_clist), tint, 1, &tstringp);
  if (!strchr(tstringp, 'S'))
  {
  	tstring = g_string_new(NULL);
  	tstringp = gtk_entry_get_text(GTK_ENTRY(import_file_label));
  	g_string_assign(tstring, tstringp);
  	tstringp = g_basename (tstring->str);
  	tstringp2 = strchr(tstringp, '.');
  	if (tstringp2)
  		*(tstringp2) = 0;
  	dialog = gnome_request_dialog (FALSE,
  						 label_enter_import_symbol,
  						 tstringp,
  						 50,
  						 (GnomeStringCallback)ok_import,
                                 NULL,
                                 NULL); 
        gtk_widget_show(dialog);
        g_string_free (tstring, TRUE);
        return;
  }
  else
  	ok_import(NULL);

}
/************************************************************************************/
void
import_cancel_button_pressed()
{
  extern GtkWidget *import_window;
  extern struct record config;

  gtk_widget_destroy(import_window);
  config.import_window_open = 0;
}
/*************************************************************************************/
gint
import_check_symbol(gchar *symbol)
{
  gint rc=0, length;
  

  length = strlen(symbol);
  if (! length)
  {
  	rc = 1;
  	return rc;
  }
  
  return rc;
}
/*************************************************************************************/
gint
import_check_date(gchar *date)
{
  gchar tstring[15], tstring2[15], tstring3[15], tstring4[15], month[5], day[5], year[10];
  gint tint, rc=0, length;
  extern GString *gstring;
  extern gchar *label_jan, *label_feb, *label_mar, *label_apr, *label_may, *label_jun;
  extern gchar *label_jul, *label_aug, *label_sep, *label_oct, *label_nov, *label_dec;
  
  
  
  /* must be > 5 and < 12 chars in length */
  length = strlen(date);
  if ((length < 6) || (length > 11))
  {
  	rc = 1;
  	return rc;
  }
  
  strcpy(tstring, date);
  
  if (strchr(tstring, '/'))
  {
  	for (tint = 0; tint < length; tint++)
	  {
	  	if (tstring[tint] == '/')
			tstring[tint] = ' ';
	  }
	sscanf(tstring, "%s %s %s", month, day, year);
  }
  else
  {
  	if (strchr(tstring, '-'))
  	{
  		for (tint = 0; tint < length; tint++)
	  	{
	  		if (tstring[tint] == '-')
				tstring[tint] = ' ';
	  	}
	  	sscanf(tstring, "%s %s %s", tstring2, tstring3, tstring4);
	  	
	  	if (strlen(tstring2) == 1)
	  	{
	  		strcpy(day, "0");
	  		strcat(day, tstring2);
	  	}
	  	else
	  		strcpy(day, tstring2);
	  		
	  	if (strlen(tstring4) == 2)
	  	{
	  		strcpy(year, "19");
	  		strcat(year, tstring4);
	  	}
	  	else
	  		strcpy(year, tstring4);	
	  		
	  	while (length >= 0)
	  	{
	  		if (strstr(tstring3, label_jan))
	  		{
	  			strcpy(month, "01");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_feb))
	  		{
	  			strcpy(month, "02");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_mar))
	  		{
	  			strcpy(month, "03");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_apr))
	  		{
	  			strcpy(month, "04");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_may))
	  		{
	  			strcpy(month, "05");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_jun))
	  		{
	  			strcpy(month, "06");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_jul))
	  		{
	  			strcpy(month, "07");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_aug))
	  		{
	  			strcpy(month, "08");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_sep))
	  		{
	  			strcpy(month, "09");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_oct))
	  		{
	  			strcpy(month, "10");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_nov))
	  		{
	  			strcpy(month, "11");
	  			break;
	  		}
	  		
	  		if (strstr(tstring3, label_dec))
	  		{
	  			strcpy(month, "12");
	  			break;
	  		}
	  	}
  	}
  	else
  	{
  		if (length == 8)
  		{
  			strcpy(tstring2, tstring);
  			tstring2[4] = 0;
  			if (atoi(tstring2) < 1300)
  			{
  				month[0] = tstring[0];
  				month[1] = tstring[1];
  				month[2] = 0;
  		
  				day[0] = tstring[2];
  				day[1] = tstring[3];
  				day[2] = 0;
  		
  				year[0] = tstring[4];
  				year[1] = tstring[5];
  				year[2] = tstring[6];
  				year[3] = tstring[7];
  				year[4] = 0;
  			}
  			else
  			{
  				month[0] = tstring[4];
  				month[1] = tstring[5];
  				month[2] = 0;
  		
  				day[0] = tstring[6];
  				day[1] = tstring[7];
  				day[2] = 0;
  		
  				year[0] = tstring[0];
  				year[1] = tstring[1];
  				year[2] = tstring[2];
  				year[3] = tstring[3];
  				year[4] = 0;
  			}
  		}
  		else
  		{
  			if (length == 6)
  			{
  				tstring2[0] = tstring[0];
  				tstring2[1] = tstring[1];
  				tstring2[2] = 0;
  				
  				tstring3[0] = tstring[2];
  				tstring3[1] = tstring[3];
  				tstring3[2] = 0;
  				
  				tstring4[0] = tstring[4];
  				tstring4[1] = tstring[5];
  				tstring4[2] = 0;
  				
  				if((atoi(tstring2) > 12) && (atoi(tstring3) < 13) && (atoi(tstring4)<32))
  				{
  					strcpy(year, tstring2);
  					strcpy(month, tstring3);
  					strcpy(day, tstring4);
  				}
  				else
  				{
  					if((atoi(tstring2) < 13) && (atoi(tstring3) < 32) && (atoi(tstring4) > 12))
  					{
  						strcpy(month, tstring2);
  						strcpy(day, tstring3);
  						strcpy(year, tstring4);
  					}
  					else
  					{
  						rc = 1;
  						return rc;
  					}
  				}
  			}
  			else
  			{
  				rc = 1;
  				return rc;
  			}
  		}
  	}
  }
  
  if (strlen(month) == 1)
  {
  	strcpy(tstring, "0");
  	strcat(tstring, month);
  	strcpy(month, tstring);
  }
  
  if (strlen(day) == 1)
  {
  	strcpy(tstring, "0");
  	strcat(tstring, day);
  	strcpy(day, tstring);
  }
  
  if (strlen(year) == 2)
  {
  	strcpy(tstring, "19");
  	strcat(tstring, year);
  	strcpy(year, tstring);
  }
  
  strcpy(tstring, year);
  strcat(tstring, month);
  strcat(tstring, day);
  	
  length = strlen(tstring);
  for (tint = 0; tint < length; tint++)
  {
	if (!isdigit (tstring[tint]))
	{
		rc = 1;
	  	return rc;
	}
  }
  
  if (! rc)
  	g_string_assign(gstring, tstring);
  
  return rc;
}
/***********************************************************************************/
gint
import_check_number(gchar *number)
{
  gint rc=0, tint, length;
  gchar tstring[15];
  extern GString *gstring;
  
  
  strcpy(tstring, number);  
  length = strlen(tstring);
  for (tint = 0; tint < length; tint++)
  {
	if (!isdigit (tstring[tint]))
	{
		if (! tstring[tint] == '.')
		{
			rc = 1;
	  		return rc;
	  	}
	}
  }
  
  if (! rc)
  {
  	if (strchr(tstring, '.'))
  	{
  		tint = length - 1;
  		while (length > 0)
  		{
  			if (tstring[tint] == '0')
  				tstring[tint] = 0;
  			else
  			{
  				if (tstring[tint] == '.')
  				{
  					tstring[tint] = 0;
  					break;
  				}
  				else
  					break;
  			}
  			tint--;
  		}
  		
  	}
  	g_string_assign(gstring, tstring);
  }  
  return rc;
}
/**************************************************************************************/
void
import_save_button()
{
  GList *list;
  gchar *tstringp, *tstringp2, *line[1];
  GString *tstring=NULL, *rule;
  gint tint=0, flag=0;
  GtkWidget *dialog;
  extern GtkWidget *import_rules_clist, *data_bar, *main_window, *import_rule_name;
  extern GtkWidget *import_edit_rule_clist;
  extern gchar *mess_already_exists, *mess_enter_rule_name, *mess_enter_date_field;
  extern gchar *mess_enter_close_field, *mess_rule_saved;
  
	

  tstringp2 =  gtk_entry_get_text(GTK_ENTRY(import_rule_name));
  if (strlen (tstringp2) < 1)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_enter_rule_name);
	gtk_widget_show(dialog);
	return;
  }
  
  while (tint >= 0)
  {
  	tstringp = NULL;
  	gtk_clist_get_text (GTK_CLIST (import_rules_clist), tint, 0, &tstringp);
  	if (tstringp == NULL)
  		break;
  	if (! strcmp(tstringp2, tstringp))
  	{
  		flag = 1;
  		dialog = gnome_app_error (GNOME_APP(main_window), mess_already_exists);
		gtk_widget_show(dialog);
		return;
  	}
  	tint++;
  }
  
  rule = g_string_new(NULL);
  tint = 0;
  while (tint >= 0)
  {
  	tstringp = NULL;
  	gtk_clist_get_text (GTK_CLIST (import_edit_rule_clist), tint, 0, &tstringp);
  	if (! tstringp)
  	{
  		tint = strlen (rule->str);
  		g_string_truncate (rule, tint);
  		break;
  	}
  	else
  	{
  		g_string_sprintfa (rule, "%s,", tstringp);
  		tint++;
  	}
  }
  
  if (! strstr (rule->str, "Date"))
  {
  	g_string_free (rule, TRUE);
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_enter_date_field);
	gtk_widget_show(dialog);
	return;
  }
  
  if (! strstr (rule->str, "Close"))
  {
  	g_string_free (rule, TRUE);
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_enter_close_field);
	gtk_widget_show(dialog);
	return;
  } 
  
  tstring = g_string_new (NULL);
  g_string_sprintf (tstring, "/gstalker/Import/%s", tstringp2);
  tstringp = NULL;
  tstringp = gnome_config_get_string (tstring->str);
  if (! tstringp)
  {
  	line[0] = tstringp2;
  	tint = gtk_clist_append (GTK_CLIST (import_rules_clist), line);
  	gtk_clist_select_row (GTK_CLIST (import_rules_clist), tint, 0);
  	g_string_sprintf (tstring, "/gstalker/Import/%s=", tstringp2);
  	gnome_config_set_string (tstring->str, rule->str);
  }
  else
  {
  	list = GTK_CLIST (import_rules_clist)->selection;
	tint = (int) list->data;
  	gtk_clist_set_text(GTK_CLIST (import_rules_clist), tint, 0, tstringp2);
  	g_string_sprintf (tstring, "/gstalker/Import/%s=", tstringp2);
  	gnome_config_set_string (tstring->str, rule->str);
  	g_free (tstring);
  }
  
  gnome_appbar_set_status (GNOME_APPBAR(data_bar), mess_rule_saved);
  g_string_free(tstring, TRUE);
  g_string_free(rule, TRUE);
  gnome_config_sync ();
  import_edit_rule_cancel();
}
/****************************************************************************************/
void
import_load_rules()
{
  FILE *infile;
  GString *tstring;
  gchar *tstringp=NULL, *line[1], buffer[1024];
  extern GtkWidget *import_rules_clist;
  
  
  if (! gnome_config_has_section("/gstalker/Import"))
	return;
	    
  tstring = g_string_new(NULL);
  tstringp = g_get_home_dir();
  g_string_sprintf (tstring, "%s/.gnome/gstalker", tstringp);
  infile = fopen(tstring->str, "r");
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
  	if (strstr(buffer, "[Import]"))
  	{
  		while (fgets (buffer, sizeof(buffer), infile) != NULL)
  		{
  			buffer[strlen(buffer) - 1] = 0;
  			tstringp = strchr(buffer, '=');
  			if (tstringp == NULL)
				break;
 			else
 			{
 				*(tstringp) = 0;
 				line[0] = buffer;
 				gtk_clist_append (GTK_CLIST (import_rules_clist), line);
  			}
  		}
  	}
  }
  fclose(infile);
  g_string_free(tstring, TRUE);
}
/******************************************************************************************/
void
import_delete_button()
{
  GtkWidget *dialog;
  gint tint;
  GList *list = NULL;
  extern GtkWidget *import_rules_clist, *main_window;
  extern gchar *mess_nothing_selected;



  list = GTK_CLIST (import_rules_clist)->selection;
  if (list)
    {
      gtk_clist_freeze (GTK_CLIST (import_rules_clist));
      tint = (int) list->data;
      gtk_clist_remove (GTK_CLIST (import_rules_clist), tint);
      gtk_clist_thaw (GTK_CLIST (import_rules_clist));
    }
  else
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
}
/***************************************************************************************/
void 
get_import_filename (GtkWidget *w, GtkFileSelection *file)
{
  gchar *tstringp=NULL, *tstringp2;
  extern GtkWidget *fs, *import_file_label;
  extern GString *lastdir;

  
  tstringp = gtk_file_selection_get_filename (GTK_FILE_SELECTION (file));
  gtk_entry_set_text (GTK_ENTRY(import_file_label), tstringp);
  tstringp2 = g_dirname(tstringp);
  g_string_sprintf (lastdir, "%s/*", tstringp2);
  g_free(tstringp2);
  gtk_widget_destroy(fs);
}
/******************************************************************************************/
void 
ok_import (gchar *callback_symbol, gint reply)
{
  gboolean error_notify_flag=FALSE, reload_flag=FALSE, rc=FALSE;
  GtkWidget *dialog;
  GList *list;
  gint tint, line=1;
  FILE *infile, *errorlog_file;
  GString *rule, *symbol, *tstring;
  gfloat tfloat = 0.0;
  gulong filesize, tlong, bytecount = 0;
  gchar *tstringp, buffer[1024];
  extern gchar *mess_invalid_symbol_entry, *mess_cant_open_importfile, *mess_cant_open_errorlog;
  extern gchar *mess_error_notify, *label_importing, *mess_import_complete;
  extern struct record config;
  extern GtkWidget *import_file_label, *data_bar, *import_rules_clist, *main_window;
  extern GString *gstring, *current_symbol;
  extern gint chartflag;

  

  symbol = g_string_new(NULL);
    
  if (callback_symbol != 0)
  {
  	g_string_assign(symbol, callback_symbol);
	if (import_check_symbol(symbol->str))
	{
		g_string_free(symbol, TRUE);
		dialog = gnome_app_error (GNOME_APP(main_window), mess_invalid_symbol_entry);
		gtk_widget_show(dialog);
		return;
	}
  }
  
  errorlog_file = fopen (config.errorlog, "w");
  if (!errorlog_file)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_cant_open_errorlog);
	gtk_widget_show(dialog);
	return;
  }
  
  tstringp = gtk_entry_get_text(GTK_ENTRY(import_file_label));
  infile = fopen (tstringp, "r");
  if (!infile)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_cant_open_importfile);
	gtk_widget_show(dialog);
	return;
  }
  
  rule = g_string_new(NULL);
  tstring = g_string_new (NULL);

  tlong = ftell(infile);
  fseek(infile, 0L, SEEK_END);
  filesize = ftell(infile) - tlong;
  bytecount = 0;
  rewind(infile);
  
  list = GTK_CLIST (import_rules_clist)->selection;
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (import_rules_clist), tint, 0, &tstringp);
  g_string_sprintf (tstring, "/gstalker/Import/%s=", tstringp);
  tstringp = gnome_config_get_string (tstring->str);
  g_string_assign(rule, tstringp);
  g_free (tstringp);

  gnome_appbar_set_status (GNOME_APPBAR(data_bar), label_importing);
  
  /* enter the import file read loop */
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
  	rc = import_record(rule, buffer, symbol->str, line);
  	if (rc)
  	{
  		error_notify_flag = TRUE;
  		fputs (gstring->str, errorlog_file);
  	}
  	
  	if (chartflag)
  	{
		if (!strcmp (symbol->str, current_symbol->str))
			reload_flag = TRUE;
  	}
  	
      	bytecount = bytecount + strlen(buffer);
      	tfloat = ((float) bytecount / filesize);
      	if (tfloat > 1.0)
		tfloat = 1.0;
      	if (tfloat < 0.0)
		tfloat = 0.0;
      	gnome_appbar_set_progress (GNOME_APPBAR(data_bar), tfloat);
      	while (gtk_events_pending ())
		gtk_main_iteration ();
	line++;
  }
    
  fclose(infile);
  fclose(errorlog_file);
  
  if (error_notify_flag)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_error_notify);
	gtk_widget_show(dialog);
	return;
  }
  
  if (reload_flag)
      load_file (symbol->str);
      
  g_string_free(symbol, TRUE);
  g_string_free(rule, TRUE);
  g_string_free (tstring, TRUE);
  
  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), 0.0);
  gnome_appbar_set_status (GNOME_APPBAR(data_bar), mess_import_complete);
}
/*****************************************************************************/
void 
open_import ()
{
  extern GtkWidget *fs;
  extern GString *lastdir;
  extern gchar *mess_select_import_file;


  fs = gtk_file_selection_new (mess_select_import_file);
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &fs);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (get_import_filename), fs);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (fs));
  gtk_window_position (GTK_WINDOW (fs), GTK_WIN_POS_CENTER);
  if (strlen(lastdir->str) > 0)
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs), lastdir->str);
  else
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs), "~/");
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fs));
  gtk_widget_show (fs);
}
/*******************************************************************************************/
void 
import_options ()
{
  GtkWidget *vbox, *vbox2, *hbox, *hbox2, *frame;
  GtkWidget *swindow, *fs_button, *space;
  GtkWidget *delete_button, *ok_button, *cancel_button, *new_button, *edit_button;
  extern GtkWidget *import_window, *import_file_label;
  extern GtkWidget *import_rules_clist;
  extern struct record config;
  extern gchar *label_import, *label_rule, *label_import_from, *label_new, *label_edit;
  extern gchar *label_delete, *label_cancel;
  


  if (config.import_window_open)
  	return;
  	
  import_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (import_window), "destroy",
	    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &import_window);
  gtk_window_position (GTK_WINDOW (import_window), GTK_WIN_POS_CENTER);
  gtk_window_set_title (GTK_WINDOW (import_window), label_import);
  gtk_container_border_width (GTK_CONTAINER (import_window), 0);
  gtk_widget_set_usize (GTK_WIDGET (import_window), 500, 0);
  
  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (import_window), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_widget_show (hbox);

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
  gtk_widget_show (vbox);
  
  vbox2 = gtk_vbutton_box_new ();
  gtk_box_pack_end (GTK_BOX (hbox), vbox2, FALSE, TRUE, 10);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox2);

  frame = gtk_frame_new (label_rule);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);
  
  space = gtk_hbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (space), 5);
  gtk_container_add (GTK_CONTAINER (frame), space);
  gtk_widget_show (space);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add (GTK_CONTAINER (space), swindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  import_rules_clist = gtk_clist_new (1);
  gtk_clist_set_selection_mode (GTK_CLIST (import_rules_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow), import_rules_clist);
  gtk_widget_set_usize (GTK_WIDGET (import_rules_clist), 0, 100);
  gtk_clist_set_column_width (GTK_CLIST(import_rules_clist), 0, 100);
  gtk_clist_set_column_title (GTK_CLIST(import_rules_clist), 0, label_rule);
  gtk_clist_column_titles_show (GTK_CLIST(import_rules_clist));
  gtk_widget_show (import_rules_clist);
  
  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
  gtk_widget_show (hbox2);

  fs_button = gtk_button_new_with_label (label_import_from);
  gtk_box_pack_start (GTK_BOX (hbox2), fs_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (fs_button), "clicked",
		      GTK_SIGNAL_FUNC (open_import), NULL);
  gtk_widget_show (fs_button);
  
  import_file_label = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (hbox2), import_file_label, TRUE, TRUE, 0);
  gtk_widget_show(import_file_label);

  ok_button = gtk_button_new_with_label (label_import);
  gtk_box_pack_start (GTK_BOX (vbox2), ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      GTK_SIGNAL_FUNC (import_ok_check), NULL);
  gtk_widget_show (ok_button);
  
  new_button = gtk_button_new_with_label (label_new);
  gtk_box_pack_start (GTK_BOX (vbox2), new_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (new_button), "clicked",
		      GTK_SIGNAL_FUNC (import_new_rule), NULL);
  gtk_widget_show (new_button);
  
  edit_button = gtk_button_new_with_label (label_edit);
  gtk_box_pack_start (GTK_BOX (vbox2), edit_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (import_edit_rule), NULL);
  gtk_widget_show (edit_button);
  
  delete_button = gtk_button_new_with_label (label_delete);
  gtk_box_pack_start (GTK_BOX (vbox2), delete_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (import_delete_button), NULL);
  gtk_widget_show (delete_button);
  
  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox2), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (import_cancel_button_pressed), NULL);
  gtk_widget_show (cancel_button);
  
  import_load_rules(import_rules_clist);
  
  config.import_window_open = 1;
    
  gtk_widget_show (import_window);
}

