/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>

#define DATE_SIZE 20 /* the size of the date area on the chart in pixels */ 
#define VOLUME_SIZE 50
#define WIDTH_OFFSET 65
#define GS_DELIMITERS "_|> <,~!@#$%^&*()+`=\{}[];:'?"
#define IMPORT_SAMPLE_RULE "Symbol,Date,Open,High,Low,Close,Volume,Open Interest"
#define IMPORT_YAHOO_RULE "Symbol,Close,Date,Ignore,Ignore,Open,High,Low,Volume"

/*** structs ***/

struct old_data
{
	unsigned long date;
	float open;
	float high;
	float low;
	float close;
	unsigned long volume;
	unsigned long openint;
};

struct old_header
{
	unsigned int version;
	char name[100];
	char symbol[25];
	unsigned long first_date;
	unsigned long last_date;
	unsigned int records;
	unsigned short styleflag;
	unsigned short pixelspace;
	unsigned short volume; /* status */
	unsigned short moving[3]; /* status, type, period */
	unsigned short moving2[3];
	unsigned short moving3[3];
	unsigned short volumeroc_status;
	unsigned short closeroc_status;
	unsigned short threshold_status;
	float volumeroc;
	float closeroc;
	float threshold;
	unsigned short ma_alert;
	unsigned short ma2_alert;
	unsigned short ma3_alert;
	char filler[828];
};

struct old_config
{
	unsigned int version;
	char last_group[250];
	char pixmap_path[250];
	unsigned int bars;
	unsigned short top_enable_flag;
	unsigned short bottom_enable_flag;
	unsigned short contract_high_flag;
	unsigned short contract_low_flag;
	unsigned short last_date_flag;
	unsigned short last_close_flag;
	unsigned short net_change_flag;
	unsigned short date_flag;
	unsigned short open_flag;
	unsigned short high_flag;
	unsigned short low_flag;
	unsigned short close_flag;
	unsigned short volume_flag;
	unsigned short openi_flag;
	unsigned short volume;
	unsigned short grid;
	unsigned short grid_red;
	unsigned short grid_green;
	unsigned short grid_blue;
	unsigned short price_red;
	unsigned short price_green;
	unsigned short price_blue;
	unsigned short volume_red;
	unsigned short volume_green;
	unsigned short volume_blue;
	unsigned short moving_red;
	unsigned short moving_green;
	unsigned short moving_blue;
	unsigned short moving2_red;
	unsigned short moving2_green;
	unsigned short moving2_blue;
	unsigned short moving3_red;
	unsigned short moving3_green;
	unsigned short moving3_blue;
	unsigned short background_red;
	unsigned short background_green;
	unsigned short background_blue;
	unsigned short border_red;
	unsigned short border_green;
	unsigned short border_blue;
	unsigned short global_indicators;
	unsigned short global_moving_status;
	unsigned short global_moving_type;
	unsigned short global_moving_length;
	unsigned short global_moving2_status;
	unsigned short global_moving2_type;
	unsigned short global_moving2_length;
	unsigned short global_moving3_status;
	unsigned short global_moving3_type;
	unsigned short global_moving3_length;
	unsigned short global_volume_status;
	unsigned short global_alerts;
	unsigned short global_alerts_moving_status;
	unsigned short global_alerts_moving2_status;
	unsigned short global_alerts_moving3_status;
	unsigned short global_alerts_closeroc_status;
	unsigned short global_alerts_threshold_status;
	unsigned short global_alerts_volumeroc_status;
	float global_threshold;
	float global_closeroc;
	float global_volumeroc;
	unsigned short style;
	unsigned short import_field;
	unsigned short import_date;
	char proxy[100];
	unsigned short port;
	char source[50];
};


/* struct for the config file */
struct record
{
  gchar grouppath[100];
  gchar datapath[100];
  gchar errorlog[100];
  gchar indexpath[100];
  gchar home [50];
  gchar version[15];
  gchar groupfile[100];
  gchar chart_type[10];
  guint bars;
  guint8 grid_red;
  guint8 grid_green;
  guint8 grid_blue;
  guint8 price_red;
  guint8 price_green;
  guint8 price_blue;
  guint8 volume_red;
  guint8 volume_green;
  guint8 volume_blue;
  guint8 moving_red;
  guint8 moving_green;
  guint8 moving_blue;
  guint8 moving2_red;
  guint8 moving2_green;
  guint8 moving2_blue;
  guint8 moving3_red;
  guint8 moving3_green;
  guint8 moving3_blue;
  guint8 background_red;
  guint8 background_green;
  guint8 background_blue;
  guint8 border_red;
  guint8 border_green;
  guint8 border_blue;
  guint8 style;
  guint8 import_field;
  unsigned short import_date;
  gchar source[50];
  guint16 group_pointer;
  guint16 group_pointer_size;
  gboolean moving_status;
  gboolean moving2_status;
  gboolean moving3_status;
  gboolean closeroc_status;
  gboolean threshold_status;
  gboolean ma_alert_status;
  gboolean ma2_alert_status;
  gboolean ma3_alert_status;
  gboolean volume_status;
  gboolean date_flag;
  gboolean open_flag;
  gboolean high_flag;
  gboolean low_flag;
  gboolean close_flag;
  gboolean volume_flag;
  gboolean openi_flag;
  gboolean grid;
  gboolean data_window_open;
  gboolean goto_chart_window_open;
  gboolean edit_indicators_window_open;
  gboolean edit_alerts_window_open;
  gboolean quotes_window_open;
  gboolean import_edit_rule_window_open;
  gboolean edit_chart_window_open;
  gboolean import_window_open;
  gfloat closeroc;
  guint8 moving_type;
  gint moving_value;
  guint8 moving2_type;
  gint moving2_value;
  guint8 moving3_type;
  gint moving3_value;
  gchar currency[10];
  gfloat currency_rate;
  gint w;
  gint h;
  gint x;
  gint y;
};

extern void alert_goto_chart();
extern void create_alert_report();
extern void ok_alert_scan();
extern void alert_scan();
extern void update_stats_bar();
extern void display_message();
extern void about();
extern void show_info_bar();
extern void hide_info_bar();
extern void show_data_bar();
extern void hide_data_bar();
extern void create_config();
extern void exit_program();
extern void read_config();
extern void toggle_volume();
extern void toggle_grid();
extern void show_data_window();
extern void ok_goto_chart();
extern void goto_chart();
extern void style_button_pressed();
extern void expand_chart();
extern void shrink_chart();
extern void next_chart();
extern void previous_chart();
extern void line_style();
extern void hlc_style();
extern void new_init();
extern void init();
extern void motion_notify_event (GtkWidget *, GdkEventMotion *);
extern void configure_event (GtkWidget *, GdkEventConfigure *);
extern void scale_configure_event (GtkWidget *, GdkEventConfigure *);
extern void expose_event (GtkWidget *, GdkEventExpose *);
extern void scale_expose_event (GtkWidget *, GdkEventExpose *);
extern void button_press_event (GtkWidget *, GdkEventButton *);
extern void volume_motion_notify_event (GtkWidget *, GdkEventMotion *);
extern void volume_configure_event (GtkWidget *, GdkEventConfigure *);
extern void volume_expose_event (GtkWidget *, GdkEventExpose *);
extern void volume_button_press_event (GtkWidget *, GdkEventButton *);
extern void date_configure_event (GtkWidget *, GdkEventConfigure *);
extern void date_expose_event (GtkWidget *, GdkEventExpose *);
extern void yes_delete_chart();
extern void delete_chart();
extern void ok_open_chart();
extern void workwith_charts();
extern void draw_date();
extern void draw_volume();
extern void draw_scale();
extern void draw_price();
extern void draw_moving_average();
extern void draw();
extern void yes_delete_record();
extern void edit_data_end();
extern void edit_data_back();
extern void edit_data_next();
extern void edit_data_start();
extern void edit_data_delete();
extern void edit_data_save();
extern void edit_chart_data();
extern void save_indicators();
extern void edit_indicators();
extern void save_options();
extern void edit_options();
extern void yes_delete_group();
extern void ok_rename_group();
extern void rename_group();
extern void edit_group_insert_button();
extern void edit_group_add_button();
extern void edit_group_delete_button();
extern void edit_group_ok_button();
extern void ok_edit_group();
extern void ok_delete_group();
extern void load_group();
extern void create_group();
extern void new_group();
extern void workwith_groups();
extern void load_first_group();
extern void get_import_filename();
extern void ok_import();
extern void open_import();
extern void import_options();
extern void save_name_dat();
extern void save_symbol_dat();
extern void save_volume_dat();
extern void save_moving_dat();
extern void save_volumeroc_dat();
extern void save_closeroc_dat();
extern void save_threshold_dat();
extern void load_alerts();
extern void load_file(gchar *);
extern void new_group();
extern void workwith_groups();
extern void workwith_charts();
extern void import_options();
extern void edit_options();
extern void edit_indicators();
extern void expand_chart();
extern void shrink_chart();
extern void line_style();
extern void hlc_style();
extern void show_data_window();
extern void goto_chart();
extern void alert_scan();
extern void about();
extern void load_first_group();
extern void button_press_event();
extern void new_init();
extern void exit_edit_indicator_window();
extern void exit_edit_options_window();
extern void edit_alerts();
extern void no_save_alerts();
extern void yes_save_alerts();
extern void exit_alerts_window();
extern void save_alerts();
extern void get_color(gchar *);
extern void get_color2(gint, gint, gint);
extern void get_object_color();
extern void set_object_color();
extern void save_chart_header();
extern void save_config();
extern void edit_options_color_changed();
extern void display_record(guint); 
extern void append_chart_record(gchar *, gulong, gfloat, gfloat, gfloat, gfloat, gulong, gulong);
extern gint create_new_chart(gchar *);
extern gint find_chart_record(gchar *, gchar *);
extern void overwrite_chart_record (gchar *, guint, gulong , gfloat, gfloat, gfloat, gfloat, gulong, gulong);
extern void insert_chart_record (gchar *, gchar *, gchar *);
extern void edit_goto_record();
extern void ok_goto_record();
extern void save_changes();
extern void show_chart_list(GtkWidget *);
extern void show_yesno_window(gchar *);
extern void show_progress_window(gchar *);
extern gfloat get_simple_movavg(gint , guint);
extern void resize_chart();
extern void show_indicator2_window();
extern void show_indicator3_window();
extern void draw_moving_average2();
extern void draw_moving_average3();
extern void update_indicator_window();
extern void update_alerts_clist();
extern gfloat get_exponential_movavg(gint, guint);
extern gfloat get_weighted_movavg(gint, guint);
extern void set_color(gint);
extern void set_color2(gint, gint, gint);
extern void scan_volumeroc();
extern void scan_closeroc();
extern void scan_threshold();
extern void scan_ma();
extern void toggle_global_indicators();
extern void menu_edit_indicators();
extern void menu_edit_alerts();
extern void menu_toggle_grid();
extern void menu_toggle_volume();
extern void menu_show_data_window();
extern void update_data_window();
extern gint check_chart_version(gchar *);
extern void show_update_quotes();
extern void ok_update_quotes();
extern void update_clist_entry(gint , gchar *, GtkWidget *);
extern void save_header(gchar *);
extern void save_temp_header(gchar *);
extern void display_chart_details(gchar *, GtkWidget *);
extern void show_portfolio();
extern void new_portfolio_item();
extern void close_portfolio_item();
extern void update_portfolio();
extern void ok_portfolio_item();
extern gint get_current_chart_height();
extern void destroy_quotes_window();
extern void destroy_portfolio_window();
extern void update_name_display();
extern void save_state();
extern void get_config();
extern void close_edit_window();
extern void edit_chart_cancel();
extern void exit_goto_chart_window();
extern void yes_save_options();
extern void import_new_rule();
extern void import_insert_button();
extern void import_delete_button();
extern void import_create_rule();
extern void import_save_button();
extern void import_rule_selected();
extern gint import_check_symbol(gchar *);
extern gint import_check_date(gchar *);
extern gint import_check_number(gchar *);
extern void import_dialog_changes();
extern void import_dialog_changes_2();
extern void import_cancel_button_pressed();
extern void import_rule_changed();
extern gint import_verify_rule(gchar *);
extern void convert_date(gchar *);
extern void convert_date2 (gchar *);
extern gint import_record(GString *, gchar *, gchar *, gint);
extern void create_ma_array (gint);
extern void create_ma2_array (gint);
extern void create_ma3_array (gint);
extern void get_index_file_type (gchar *);
extern void get_index_symbol (gchar *);
extern void get_index_name (gchar *);
extern void get_index_first_date (gchar *);
extern void get_index_last_date (gchar *);
extern gint get_index_records (gchar *);
extern gint get_index_line_pixelspace (gchar *);
extern gint get_index_ohlc_pixelspace (gchar *);
extern gfloat get_index_threshold (gchar *);
extern void save_index_file_type (gchar *, gchar *);
extern void save_index_symbol (gchar *);
extern void save_index_name (gchar *, gchar *);
extern void save_index_first_date (gchar *, gchar *);
extern void save_index_last_date (gchar *, gchar *);
extern void save_index_records (gchar *, gint);
extern void save_index_line_pixelspace (gchar *, gint);
extern void save_index_ohlc_pixelspace (gchar *, gint);
extern void save_index_threshold (gchar *, gfloat);
extern void data_selected();
extern void edit_data_insert();
extern void parse_quotes(gchar *);
extern void quote_get_date_window();
extern void create_gdate_from_string (gchar *);
extern void chart_array_append (glong, gfloat, gfloat, gfloat, gfloat, glong, glong);
extern void set_chart_type ();
extern void convert_old_chart ();
extern void import_new_rule();
extern void import_edit_rule();
extern void create_import_edit_rule_window();
extern void update_alerts_window();
extern void exit_nicely();


