/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"
#include <dirent.h>

/***********************************************************************************
destroys the goto chart window.
***********************************************************************************/
void
exit_goto_chart_window()
{
  extern GtkWidget *goto_chart_window;
  extern struct record config;
	
  config.goto_chart_window_open = 0;
  gtk_widget_destroy(goto_chart_window);
	
}
/*************************************************************************************
loads the chart selected from the goto chart window.
**************************************************************************************/
void 
ok_goto_chart ()
{
  gchar *tstringp;
  gint tint;
  GList *list;
  GtkWidget *dialog;
  extern GtkWidget *goto_chart_clist, *main_window;
  extern gchar *mess_nothing_selected;
  extern struct record config;


  list = GTK_CLIST (goto_chart_clist)->selection;
  if (list)
    {
      tint = (int) list->data;
      gtk_clist_get_text (GTK_CLIST (goto_chart_clist), tint, 0, &tstringp);
      load_file (tstringp);
      config.group_pointer = tint;
      if (config.goto_chart_window_open)
      	exit_goto_chart_window();
    }
  else
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
}
/**************************************************************************************
create the goto chart window.
***********************************************************************************/
void 
goto_chart ()
{
  gint tint;
  GtkVisibility visible;
  gchar *tstringp;
  GtkWidget *vbox, *hbox, *button, *button2, *hsep, *swindow;
  extern GtkWidget *goto_chart_window, *goto_chart_clist;
  extern gint chartflag, open_file_flag;
  extern struct record config;
  extern GPtrArray *group_array;
  extern gchar *label_start, *label_end, *label_symbol, *label_name, *label_goto_chart;
  extern gchar *label_ok, *label_cancel;
  


  if (chartflag == 0)
    return;
  if (open_file_flag)
    return;
    
  if (config.goto_chart_window_open)
    {
      gtk_clist_select_row (GTK_CLIST (goto_chart_clist), config.group_pointer, 0);
      visible = gtk_clist_row_is_visible (GTK_CLIST (goto_chart_clist), config.group_pointer);
      if ((visible == GTK_VISIBILITY_PARTIAL) || (visible == GTK_VISIBILITY_NONE))
	gtk_clist_moveto (GTK_CLIST (goto_chart_clist), config.group_pointer, 0, 0.5, 0);
      return;
    }

  goto_chart_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (goto_chart_window), "destroy",
		GTK_SIGNAL_FUNC (gtk_widget_destroyed), &goto_chart_window);
  gtk_window_position (GTK_WINDOW (goto_chart_window), GTK_WIN_POS_CENTER);
  gtk_window_set_title (GTK_WINDOW (goto_chart_window), label_goto_chart);
  gtk_widget_set_usize (GTK_WIDGET (goto_chart_window), 0, 0);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_container_add (GTK_CONTAINER (goto_chart_window), vbox);
  gtk_widget_show (vbox);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start (GTK_BOX (vbox), swindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  goto_chart_clist = gtk_clist_new_with_titles (4, NULL);
  gtk_clist_set_column_width (GTK_CLIST (goto_chart_clist), 0, 70);
  gtk_clist_set_column_width (GTK_CLIST (goto_chart_clist), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (goto_chart_clist), 2, 70);
  gtk_clist_set_column_width (GTK_CLIST (goto_chart_clist), 3, 70);
  gtk_clist_set_selection_mode (GTK_CLIST (goto_chart_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow), goto_chart_clist);
  gtk_container_border_width (GTK_CONTAINER (goto_chart_clist), 10);
  gtk_widget_set_usize (GTK_WIDGET (goto_chart_clist), 500, 200);
  gtk_clist_set_column_title (GTK_CLIST(goto_chart_clist), 0, label_symbol);
  gtk_clist_set_column_title (GTK_CLIST(goto_chart_clist), 1, label_name);
  gtk_clist_set_column_title (GTK_CLIST(goto_chart_clist), 2, label_start);
  gtk_clist_set_column_title (GTK_CLIST(goto_chart_clist), 3, label_end);
  gtk_clist_column_titles_show (GTK_CLIST(goto_chart_clist));
  gtk_widget_show (goto_chart_clist);

  hsep = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
  gtk_widget_show (hsep);

  hbox = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
  gtk_hbutton_box_set_spacing_default (10);
  gtk_hbutton_box_set_layout_default (GTK_BUTTONBOX_END);
  gtk_widget_show (hbox);

  button = gtk_button_new_with_label (label_ok);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (ok_goto_chart), NULL);
  gtk_widget_show (button);

  button2 = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			     GTK_SIGNAL_FUNC (exit_goto_chart_window), NULL);
  gtk_widget_show (button2);

  gtk_clist_freeze (GTK_CLIST (goto_chart_clist));
  
  for (tint = 0; tint <= config.group_pointer_size; tint++)
  {
  	tstringp = g_ptr_array_index (group_array, tint);
      	display_chart_details (tstringp, goto_chart_clist);
  }
  gtk_widget_show (goto_chart_window);
  config.goto_chart_window_open = 1;

  gtk_clist_select_row (GTK_CLIST (goto_chart_clist), config.group_pointer, 0);
  visible = gtk_clist_row_is_visible (GTK_CLIST (goto_chart_clist), config.group_pointer - 1);
  if ((visible == GTK_VISIBILITY_PARTIAL) || (visible == GTK_VISIBILITY_NONE))
    gtk_clist_moveto (GTK_CLIST (goto_chart_clist), config.group_pointer, 0, 0.5, 0);
  gtk_clist_thaw (GTK_CLIST (goto_chart_clist));
}
/****************************************************************************************
delete the chart and index files.
***************************************************************************************/
void 
yes_delete_chart (gint reply)
{
  FILE *infile, *outfile;
  struct dirent **dirlist;
  GString *tstring, *chart, *oldgroup, *newgroup;
  gchar buffer[1024], *tstringp;
  GList *list;
  gint tint, tint2;
  extern GtkWidget *workwith_charts_clist;
  extern struct record config;
  extern GPtrArray *group_array;
  extern GString *current_symbol;

  
  
  if (reply)
  	return;
  	
  tstring = g_string_new(NULL);
  chart = g_string_new(NULL);
  oldgroup = g_string_new(NULL);
  newgroup = g_string_new(NULL);

  list = GTK_CLIST (workwith_charts_clist)->selection;
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_charts_clist), tint, 0, &tstringp);
  g_string_sprintf (tstring, "%s%s", config.datapath, tstringp);
  g_string_assign (chart, tstringp);
  unlink (tstring->str);
  g_string_sprintf (tstring, "%s%s", config.indexpath, tstringp);
  unlink (tstring->str);
  gtk_clist_freeze (GTK_CLIST (workwith_charts_clist));
  gtk_clist_remove (GTK_CLIST (workwith_charts_clist), tint);
  gtk_clist_thaw (GTK_CLIST (workwith_charts_clist));

  tint = scandir (config.grouppath, &dirlist, NULL, alphasort);
  if (tint < 0)
    return;
  tint2 = tint;
  for (tint = 2; tint < tint2; tint++)
    {
      g_string_sprintf (oldgroup, "%s%s", config.grouppath, dirlist[tint]->d_name);
      infile = fopen(oldgroup->str, "r");
      g_string_sprintf (newgroup, "%s%s", config.grouppath, "temp.txt");
      outfile = fopen(newgroup->str, "w");
      while (fgets (buffer, sizeof(buffer), infile) != NULL)
      {
      		g_strstrip (buffer);
      		if (strcmp (buffer, chart->str))
      		{
      			fputs(buffer, outfile);
      			fputs("\n", outfile);
      		}
      }
      fclose(infile);
      fclose(outfile);
      unlink(oldgroup->str);
      rename (newgroup->str, oldgroup->str);
    }
    
  g_string_free(tstring, TRUE);
    
  for (tint=0; tint <= config.group_pointer_size; tint++)
  {
  	tstringp = g_ptr_array_index (group_array, tint);
  	if (! strcmp (tstringp, chart->str))
  	{
  		if (group_array)
  			g_ptr_array_free (group_array, TRUE);
  		group_array = g_ptr_array_new();
  		infile = fopen(oldgroup->str, "r");
  		while (fgets (buffer, sizeof(buffer), infile) != NULL)
  		{
  			g_strstrip (buffer);
  			tstring = g_string_new (NULL);
  			g_string_assign (tstring, buffer);
  			g_ptr_array_add (group_array, (gpointer) tstring->str);
  		}
  		fclose(infile);
  		config.group_pointer_size--;
  		if (config.group_pointer > config.group_pointer_size)
  			config.group_pointer = config.group_pointer_size;
  		if (! strcmp (chart->str, current_symbol->str))
  		{
  			tstringp = g_ptr_array_index (group_array, config.group_pointer);
  			load_file (tstringp);
  			break;
  		}
  	}
  }
  
  g_string_free(chart, TRUE);
  g_string_free(oldgroup, TRUE);
  g_string_free(newgroup, TRUE);
}
/*****************************************************************************************
pop up the delete chart dialog.
******************************************************************************************/
void 
delete_chart ()
{
  GList *list;
  gint tint;
  GString *tstring;
  gchar *tstringp;
  GtkWidget *dialog;
  extern GtkWidget *workwith_charts_clist, *main_window;
  extern gchar *mess_nothing_selected, *mess_delete_confirm;


  list = GTK_CLIST (workwith_charts_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  
  tstring = g_string_new(NULL);
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_charts_clist), tint, 0, &tstringp);
  g_string_sprintf (tstring, "%s%s ?", mess_delete_confirm, tstringp);
  
  dialog = gnome_app_question_modal (GNOME_APP(main_window),
  							 tstring->str,
  							 (GnomeReplyCallback)yes_delete_chart,
  							 (gpointer) tstringp);
  gtk_widget_show(dialog);
  
  g_string_free(tstring, TRUE);
}
/***********************************************************************************
loads the chart selected from the workwith charts window.
***********************************************************************************/
void 
ok_open_chart ()
{
  GList *list;
  gint tint;
  gchar *tstringp;
  GtkWidget *dialog;
  extern gint open_file_flag;
  extern GtkWidget *workwith_charts_clist, *workwith_charts_window, *main_window;
  extern gchar *mess_nothing_selected;


  list = GTK_CLIST (workwith_charts_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_charts_clist), tint, 0, &tstringp);
  open_file_flag = 1;
  load_file (tstringp);
  if (workwith_charts_window)
    gtk_widget_destroy (workwith_charts_window);
}
/****************************************************************************************
creates the workwith charts window.
*****************************************************************************************/
void 
workwith_charts ()
{
  GtkWidget *vbox, *hbox, *open_button, *edit_button, *delete_button, *cancel_button;
  GtkWidget *swindow;
  extern GtkWidget *workwith_charts_window, *workwith_charts_clist, *workwith_groups_window;
  extern gchar *label_start, *label_end, *label_symbol, *label_name;
  extern gchar *label_workwith_charts, *label_open, *label_edit;
  extern gchar *label_delete, *label_cancel;


  if (workwith_charts_window)
    return;
  if (workwith_groups_window)
    return;

  workwith_charts_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (workwith_charts_window), "destroy",
	   GTK_SIGNAL_FUNC (gtk_widget_destroyed), &workwith_charts_window);
  gtk_window_position (GTK_WINDOW (workwith_charts_window), GTK_WIN_POS_CENTER);
  gtk_window_set_title (GTK_WINDOW (workwith_charts_window), label_workwith_charts);
  gtk_container_border_width (GTK_CONTAINER (workwith_charts_window), 0);
  gtk_widget_set_usize (GTK_WIDGET (workwith_charts_window), 600, 300);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (workwith_charts_window), hbox);
  gtk_widget_show (hbox);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), swindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  workwith_charts_clist = gtk_clist_new_with_titles (4, NULL);
  gtk_clist_set_column_width (GTK_CLIST (workwith_charts_clist), 0, 70);
  gtk_clist_set_column_width (GTK_CLIST (workwith_charts_clist), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (workwith_charts_clist), 2, 70);
  gtk_clist_set_column_width (GTK_CLIST (workwith_charts_clist), 3, 70);
  gtk_clist_set_selection_mode (GTK_CLIST (workwith_charts_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow), workwith_charts_clist);
  gtk_container_border_width (GTK_CONTAINER (workwith_charts_clist), 0);
  gtk_widget_set_usize (GTK_WIDGET (workwith_charts_clist), 465, 0);
  gtk_clist_set_column_title (GTK_CLIST(workwith_charts_clist), 0, label_symbol);
  gtk_clist_set_column_title (GTK_CLIST(workwith_charts_clist), 1, label_name);
  gtk_clist_set_column_title (GTK_CLIST(workwith_charts_clist), 2, label_start);
  gtk_clist_set_column_title (GTK_CLIST(workwith_charts_clist), 3, label_end);
  gtk_clist_column_titles_show (GTK_CLIST(workwith_charts_clist));
  gtk_widget_show (workwith_charts_clist);

  vbox = gtk_vbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox);

  open_button = gtk_button_new_with_label (label_open);
  gtk_box_pack_start (GTK_BOX (vbox), open_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (open_button), "clicked",
		      GTK_SIGNAL_FUNC (ok_open_chart), NULL);
  gtk_widget_show (open_button);

  edit_button = gtk_button_new_with_label (label_edit);
  gtk_box_pack_start (GTK_BOX (vbox), edit_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_chart_data), NULL);
  gtk_widget_show (edit_button);

  delete_button = gtk_button_new_with_label (label_delete);
  gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (delete_chart), NULL);
  gtk_widget_show (delete_button);

  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (workwith_charts_window));
  gtk_widget_show (cancel_button);

  show_chart_list (workwith_charts_clist);
  gtk_widget_show (workwith_charts_window);
}
