/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev, Christian Lupien and Chris Hardy

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_TVOUT_H
#define GATOS_TVOUT_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_TVOUT_C
#define WHERE
#else
#define WHERE	extern
#endif

/* ImpacTV family chip ID's */

/* ImpacTV */
#define IMPACTV		0x1A
/* ImpacTV2 */
#define IMPACTV2	0x0B
#define IMPACTV2M	0x1B
/* ImpacTV2+ */
#define IMPACTV2P	0x31
#define IMPACTV2PM	0x30

/* ImpacTV registers */
#define TV_MASTER_CNTL		0x0010
#define TV_RGB_CNTL		0x0012
#define TV_CLKOUT_CNTL		0x0013
#define TV_SYNC_CNTL		0x0014
#define TV_I2C_CNTL		0x0015
#define TV_MPP_DATA_CNTL	0x0016
#define TV_HTOTAL		0x0020
#define TV_HDISP		0x0021
#define TV_HSIZE		0x0022
#define TV_HSTART		0x0023
#define TV_HCOUNT		0x0024
#define TV_VTOTAL		0x0025
#define TV_VDISP		0x0026
#define TV_VCOUNT		0x0027
#define TV_FTOTAL		0x0028
#define TV_FCOUNT		0x0029
#define TV_FRESTART		0x002A
#define TV_HRESTART		0x002B
#define TV_VRESTART		0x002C
#define TV_SYNC_SIZE		0x002D
#define TV_TV_PLL_CNTL		0x0030
#define TV_CRT_PLL_CNTL		0x0031
#define TV_PLL_CNTL		0x0032
#define TV_PLL_TEST_CNTL	0x0033
#define TV_CLOCK_SEL_CNTL	0x0034
#define TV_FRAME_LOCK_CNTL	0x0040
#define TV_SYNC_LOCK_CNTL	0x0041
#define TV_TVO_SYNC_PAT_ACCUM	0x0042
#define TV_TVO_SYNC_THRESHOLD	0x0043
#define TV_TVO_SYNC_PAT_EXPECT	0x0044
#define TV_DELAY_ONE_MAP_A	0x0045
#define TV_DELAY_ONE_MAP_B	0x0046
#define TV_DELAY_ZERO_MAP_A	0x0047
#define TV_DELAY_ZERO_MAP_B	0x0048
#define TV_TVO_DATA_DELAY_A	0x0050
#define TV_TVO_DATA_DELAY_B	0x0051
#define TV_HOST_READ_DATA	0x0060
#define TV_HOST_WRITE_DATA	0x0061
#define TV_HOST_RD_WT_CNTL	0x0062
#define TV_VSCALER_CNTL		0x0070
#define TV_TIMING_CNTL		0x0071
#define TV_GAMMA_CNTL		0x0072
#define TV_Y_FALL_CNTL		0x0073
#define TV_Y_RISE_CNTL		0x0074
#define TV_Y_SAW_TOOTH_CNTL	0x0075
#define TV_MODULATOR_CNTL1	0x0080
#define TV_MODULATOR_CNTL2	0x0081
#define TV_PRE_DAC_MUX_CNTL	0x0090
#define TV_TV_DAC_CNTL		0x00A0
#define TV_CRC_CNTL		0x00B0
#define TV_VIDEO_PORT_SIG	0x00B1
#define TV_VBI_20BIT_CNTL	0x00BA
#define TV_VBI_LEVEL_CNTL	0x00BE
#define TV_UV_ADR		0x00C0
#define TV_FIFO_TEST_CNTL	0x00C1

/* TV Out (ImpacTV) function declarations */

int	tvout_init(void) ;
void	tvout_dumpregs(void) ;
int	tvout_present(void) ;
u8	tvout_read_i2c_cntl8(void) ;
void	tvout_write_i2c_cntl8(u8) ;
u32	tvout_read32(u16) ;
void	tvout_write32(u16, u32) ;

#ifdef GATOS_TVOUT_C
static void	tvout_addr(u16) ;
static int	mpp_wait(char*) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
