/*
==============================================================================
        chadic.h
                1990/12/06/Thu  Yutaka MYOKI(Nagao Lab., KUEE)
                1990/01/09/Wed  Last Modified
                                          >>> 94/02 changed by T.Nakamura <<<
==============================================================================
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>

#include <sys/types.h>
#include <sys/stat.h>
#ifdef _WIN32
#include <io.h>
#else
#include <sys/file.h>
#endif
#include <time.h>

#include <stdlib.h>
#include <fcntl.h>

#include "config.h"

/*
 * macros
 */

#ifndef FALSE
#define         FALSE           ((int)(0))
#endif
#ifndef TRUE
#define         TRUE            (!(FALSE))
#endif

#ifdef _WIN32
#define PATH_DELIMITER  '\\'
#else
#define PATH_DELIMITER  '/'
#endif

#ifndef SEEK_SET
#define SEEK_SET        0       /* use in "fseek()"         */
#define SEEK_CUR        1       /* use in "fseek()"         */
#define SEEK_END        2       /* use in "fseek()"         */
#endif

#define CHA_FILENAME_MAX 1024

#define MIDASI_MAX	129		/* maximum length of MIDASI */

#define CLASSIFY_NO	128

#define TYPE_NO		256
#define FORM_NO		128

#define JSTR_BUNTO           "ʸƬ"
#define JSTR_BUNMATSU        "ʸ"
#define JSTR_BKUGIRI         ""
#define ESTR_BOS_EOS         "BOS/EOS"

/* cforms.cha */
#define JSTR_BASIC_FORM  "ܷ"
#define ESTR_BASIC_FORM  "BASIC"

/* *.dic */
#define JSTR_DEF_POS_COST  "ǥեʻ쥳"
#define ESTR_DEF_POS_COST  "DEF_POS_COST"
#define JSTR_POS           "ʻ"
#define ESTR_POS           "POS"
#define JSTR_WORD          "Ф"
#define ESTR_WORD          "LEX"
#define JSTR_READING       "ɤ"
#define ESTR_READING       "READING"
#define JSTR_BASE          ""
#define ESTR_BASE          "BASE"
#define JSTR_PRON          "ȯ"
#define ESTR_PRON          "PRON"
#define JSTR_CTYPE         "ѷ"
#define ESTR_CTYPE         "CTYPE"
#define JSTR_INFO          "̣"
#define ESTR_INFO          "INFO"
#define JSTR_CONN_ATTR     "Ϣ°"

/* chasenrc */
#define JSTR_GRAM_FILE      "ʸˡե"
#define ESTR_GRAM_FILE      "GRAMMAR"
#define JSTR_UNKNOWN_WORD1  "̤θ"
#define JSTR_UNKNOWN_WORD2  "̤"
#define ESTR_UNKNOWN_WORD   "UNKNOWN"
#ifdef VGRAM
#define JSTR_UNKNOWN_WORD   JSTR_UNKNOWN_WORD1
#else
#define JSTR_UNKNOWN_WORD   JSTR_UNKNOWN_WORD2
#endif
#define JSTR_UNKNOWN_POS1   "̤θʻ"
#define JSTR_UNKNOWN_POS2   "̤ʻ"
#define ESTR_UNKNOWN_POS    "UNKNOWN_POS"
#define JSTR_SPACE_POS      "ʻ"
#define ESTR_SPACE_POS      "SPACE_POS"
#define JSTR_ANNOTATION     ""
#define ESTR_ANNOTATION     "ANNOTATION"
#define JSTR_POS_COST       "ʻ쥳"
#define ESTR_POS_COST       "POS_COST"
#define JSTR_CONN_WEIGHT    "ϢܥȽŤ"
#define ESTR_CONN_WEIGHT    "CONN_WEIGHT"
#define JSTR_MRPH_WEIGHT    "ǥȽŤ"
#define ESTR_MRPH_WEIGHT    "MORPH_WEIGHT"
#define JSTR_COST_WIDTH     ""
#define ESTR_COST_WIDTH     "COST_WIDTH"
#define JSTR_DEF_CONN_COST  "̤Ϣܥ"
#define ESTR_DEF_CONN_COST  "DEF_CONN_COST"
#define JSTR_COMPO_POS      "Ϣʻ"
#define ESTR_COMPO_POS      "COMPOSIT_POS"
#define ESTR_PAT_FILE       "PATDIC" /* changed by Tatuo 960920 */
#define ESTR_SUF_FILE       "SUFDIC"
#define JSTR_OUTPUT_FORMAT  "ϥեޥå"
#define ESTR_OUTPUT_FORMAT  "OUTPUT_FORMAT"
#define JSTR_LANG           ""
#define ESTR_LANG           "LANG"
#define JSTR_DELIMITER      "ڤʸ"
#define ESTR_DELIMITER      "DELIMITER"
#define JSTR_BOS_STR        "BOSʸ"
#define ESTR_BOS_STR        "BOS_STRING"
#define JSTR_EOS_STR        "EOSʸ"
#define ESTR_EOS_STR        "EOS_STRING"

#define VCHA_CONNECT_FILE "connect.cha"
#define VCHA_CONNTMP_FILE "_connect.cha"
#define VCHA_GRAMMAR_FILE "grammar.cha"
#define VCHA_CFORM_FILE   "cforms.cha"
#define VCHA_CTYPE_FILE   "ctypes.cha"
#define VCHA_TABLE_FILE   "table.cha"
#define VCHA_MATRIX_FILE  "matrix.cha"
#define CHA_CONNECT_FILE  "chasen.connect.c"
#define CHA_CONNTMP_FILE  "chasen.connect"
#define CHA_GRAMMAR_FILE  "chasen.grammar"
#define CHA_CFORM_FILE    "chasen.cforms"
#define CHA_CTYPE_FILE    "chasen.ctypes"
#define CHA_TABLE_FILE    "chasen.table"
#define CHA_MATRIX_FILE   "chasen.matrix"
#define JM_CONNECT_FILE   "JUMAN.connect.c"
#define JM_CONNTMP_FILE   "JUMAN.connect"
#define JM_GRAMMAR_FILE   "JUMAN.grammar"
#define JM_CFORM_FILE     "JUMAN.katuyou"
#define JM_CTYPE_FILE     "JUMAN.kankei"
#define JM_TABLE_FILE     "JUMANTREE.table"
#define JM_MATRIX_FILE    "JUMANTREE.matrix"
#ifdef VGRAM
#define CONNECT_FILE	VCHA_CONNECT_FILE
#define CONNTMP_FILE	VCHA_CONNTMP_FILE
#define GRAMMAR_FILE	VCHA_GRAMMAR_FILE
#define CFORM_FILE	VCHA_CFORM_FILE
#define CTYPE_FILE	VCHA_CTYPE_FILE
#define TABLE_FILE	VCHA_TABLE_FILE
#define MATRIX_FILE	VCHA_MATRIX_FILE
#else
#define CONNECT_FILE	CHA_CONNECT_FILE
#define CONNTMP_FILE	CHA_CONNTMP_FILE
#define GRAMMAR_FILE	CHA_GRAMMAR_FILE
#define CFORM_FILE	CHA_CFORM_FILE
#define CTYPE_FILE	CHA_CTYPE_FILE
#define TABLE_FILE	CHA_TABLE_FILE
#define MATRIX_FILE	CHA_MATRIX_FILE
#endif

#define CONS		0
#define ATOM		1
#define NIL		((cell_t *)(NULL))

#define s_tag(cell)	(((cell_t *)(cell))->tag)
#define consp(x)	(!nullp(x) && (s_tag(x) == CONS))
#define atomp(x)	(!nullp(x) && (s_tag(x) == ATOM))
#define nullp(cell)	((cell) == NIL)
#define car_val(cell)	(((cell_t *)(cell))->value.cons.car)
#define cdr_val(cell)	(((cell_t *)(cell))->value.cons.cdr)
#define s_atom_val(cell) (((cell_t *)(cell))->value.atom)

/* added by T.Utsuro for weight of rensetu matrix */
#define DEFAULT_C_WEIGHT  10

/* added by S.Kurohashi for mrph weight default values */
#ifdef VGRAM
#define MRPH_DEFAULT_WEIGHT	1
#else
#define MRPH_DEFAULT_WEIGHT	10
#endif

#define strmatch2(s,s1,s2)      (!strcmp(s,s1)||!strcmp(s,s2))
#define strmatch3(s,s1,s2,s3)   (!strcmp(s,s1)||!strcmp(s,s2)||!strcmp(s,s3))

/* rensetu matrix */
typedef struct _connect_rule_t {
    unsigned short next;
    unsigned short cost;
} connect_rule_t;

/*
 * structures
 */

/* <car>  <cdr> ؤΥݥ󥿤ɽ줿 */
typedef struct _bin_t {
    void *car;			/* address of <car> */
    void *cdr;			/* address of <cdr> */
} bin_t;

/* <BIN> ޤ ʸ ɽ봰ʹ¤ */
typedef struct _cell {
    int tag;			/* tag of <cell> 0:cons 1:atom */
    union {
	bin_t	cons;
	char	*atom;
    } value;
} cell_t;

/* changed by T.Nakamura and S.Kurohashi 
	¤ mrph_t ٤Ƥξ 
	¤ MORPHEME Ϥʤʤä */
typedef struct _mrph {
    char	midasi[MIDASI_MAX];
    char	yomi[MIDASI_MAX];
    char	*info;
#ifdef VGRAM
    char	*base;
    char	pron[MIDASI_MAX];
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char ktype;
    unsigned char kform;

    short	con_tbl;
    short	length;
    unsigned short weight;

    char	is_undef;
} mrph_t;

#ifdef VGRAM
typedef struct _hinsi_t {
    short *path;
    short *daughter;
    char  *name;
    char  *bkugiri;
    short comp; /* Ϣʻֹ */
    char  depth;
    char  kt;
    unsigned char cost;
} hinsi_t;
#else
/* ʻʬࡦʬ */
typedef struct _class {
    char *id;
    unsigned char comp; /* 1:ʬबϢʻ 2:ʬबϢʻ */
    char kt;
    unsigned char cost; /*ʻ쥳 by k.n*/
} class_t;
#endif

/* ѷ */
typedef struct _ktype {
    char   *name;
    short  basic;
} ktype_t;

/* ѷ */
typedef struct _kform {
    char  *name;
    char  *gobi;
    char  *ygobi;
#ifdef VGRAM
    char  *pgobi;
#endif
} kform_t;

/* Ϣɽ */
typedef struct _rensetu_pair {
    short  index;
    short  i_pos;
    short  j_pos;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char type;
    unsigned char form;
    char   *goi;
} rensetu_pair_t;


/*
 * global variables
 */

#ifdef VGRAM
#define HINSI_MAX     4096
extern hinsi_t Hinsi[HINSI_MAX];
#else
extern class_t Class[CLASSIFY_NO][CLASSIFY_NO];
#endif
extern ktype_t Type[TYPE_NO];
extern kform_t Form[TYPE_NO][FORM_NO];
extern int LineNo, LineNoForError;

/* getopt.c */
extern int Cha_optind;
extern char *Cha_optarg;

extern int Cha_server_mode;
extern int Cha_errno;
extern FILE *Cha_stderr;

/*
 * functions
 */

/* iotool.c */
extern char *convert_escape();
extern void set_progpath();
extern void set_chasenrc_path();
extern char *get_chasenrc_path();
extern char *get_grammar_dir();
extern void set_filepath();
extern FILE *cha_fopen();
extern FILE *cha_fopen2();
extern FILE *cha_fopen_grammar();
extern FILE *cha_fopen_grammar2();
extern int  cha_feof();
extern void *cha_malloc();
extern char *cha_strdup();

extern void cha_fexit();
extern void cha_exit();
extern void cha_exit_file();
extern void cha_perror();
extern void cha_exit_perror();
extern FILE *fopen_chasenrc();
extern void read_grammar_dir();


/* lisp.c */
extern void set_cha_getc_alone();
extern void set_cha_getc_server();
extern void set_skip_char();
extern int s_feof();
extern cell_t *tmp_atom();
extern cell_t *cons();
extern cell_t *car();
extern cell_t *cdr();
extern char *s_atom();
extern int equal();
extern int s_length();
extern cell_t *s_read();
extern cell_t *assoc();
extern char *s_tostr();
extern cell_t *s_print();

/* grammar.c */
extern int match_nhinsi();
extern void read_grammar();

/* katuyou.c */
extern void read_katuyou();

/* connect.c */
extern void read_table();
extern int check_table(); /* 970301 tatuo: void -> int for  */
extern int check_table_for_undef();
extern void read_matrix();
extern int check_automaton();
/* for EDR dic */
extern void check_edrtable();
extern void check_edrtable_str();

/* getid.c */
#ifdef VGRAM
extern int get_nhinsi_str_id();
extern int get_nhinsi_id();
#else
extern int get_hinsi_id();
extern int get_bunrui_id();
extern void get_hinsi_bunrui_id();
#endif
extern int get_type_id();
extern int get_form_id();

/* zentohan.c */
extern char *zentohan();
extern char *hantozen();
extern unsigned char *euc2sjis();
extern unsigned char *sjis2euc();
extern unsigned char *hankana2zenkana();

/* getopt.c */
extern int cha_getopt();
extern int cha_getopt_chasen();

