#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>

#include "suerr.h"

/* $Id: sumove.c,v 1.1 1999/11/27 21:41:00 mag Exp $ */

/*
 * Moves stdin to argv[1].
 * File path+name is limited to 128 character!
 */
 
int main(int argc, char *argv[])
{	char buf[1024];
	char *targetfile="";
	FILE *ftarget;
	int i;
	size_t rwsize;
	struct passwd *barracuda_user, *curr_user;

	/* Proper number of params */
	if (argc<2) exit(ERR_PARAMS_NUM);
	
	/* Running user exists and match */
	if ((curr_user=getpwuid(getuid()))==NULL) exit(ERR_NO_SRCUSER);
	if (strcmp(HTTPD_USER, curr_user->pw_name)) exit(ERR_USER_MISMATCH);
	
	if ((targetfile=strdup(argv[1]))==NULL) exit(ERR_MEM);
	if (strlen(targetfile)>128) targetfile[128]=0; /* Truncate */

	/* Target file name should contain only [a-z][A-Z][0-9].- but not '..' */
	for (i=0; i<128 && targetfile[i]; i++)	{
		int c;
		
		c=targetfile[i];
		if ((c>='a' && c<='z') ||
			(c>='A' && c<='Z') ||
			(c>='0' && c<='9') ||
			(c=='.' && targetfile[i+1]!='.') ||
			c=='-'
		) continue;
		else exit(ERR_FILENAME);
	}
	/* Move as root to ensure read and write rights on both side */
	if ((barracuda_user=getpwnam(BARRACUDA_USER))==NULL) exit(ERR_NO_DESTUSER);
	umask(0077);
	if (chdir(barracuda_user->pw_dir)) exit(ERR_CHDIR_FAILS);
	if ((ftarget=fopen(targetfile, "w"))==NULL) exit(ERR_CP_FAILS);
	do {
		rwsize=fread(buf, 1, 1024, stdin);
		if (ferror(stdin)) {
			fclose(ftarget);
			remove(targetfile);
			exit(ERR_CP_FAILS);
		}
		else {
			rwsize=fwrite(buf, 1, rwsize, ftarget);
			if (ferror(ftarget)) {
				fclose(ftarget);
				remove(targetfile);
				exit(ERR_CP_FAILS);
			}
		}
	} while (!feof(stdin));
	
	/* chown the target to barracuda */
	if (chown(targetfile, barracuda_user->pw_uid,  barracuda_user->pw_gid)) exit(ERR_CHOWN_FAILS);

	/* Normal termination */
	exit(0);
}
