%{
/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: appindex.y,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "appindex.h"

extern int yyerror(char * msg);

%}

%union {
    char *	sval;
    int		ival;
};

/* appindex.conf tokens */
%token BROWSER COLOR APPINDEXURL DOWNLOAD

%start ConfigS

%token <ival> INTEGER
%token <sval> STRING

%%

ConfigS:	ConfigS Config
	|
	;

Config:
			Browser | Color | AppindexURL | Download;

Browser:		BROWSER  STRING
		{ browser = strdup($2); }
	;

AppindexURL:		APPINDEXURL  STRING
		{ appindexurl = strdup($2); }
	;

Download:		DOWNLOAD  STRING
		{ download = strdup($2); }
	;

Color:		COLOR INTEGER INTEGER INTEGER
		{ 
                  if ( ($2<0) || ($2 > COLOR_MAX) )
                   {
                    fprintf(stderr,"Color number out of range\n");
                    exit(2);
                   }
                  colors[$2] = ($3<<4) | $4;
                }
	;
%%

