/*
    Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/
 
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

static Pixmap SiagIcon, SiagMask;

/* ---
Set the icon for an application.
*/

void icon_set(Widget toplevel, char **icon_data)
{
	XWMHints *hints;
	Display *dpy = XtDisplay(toplevel);
	int Width, Height;
	int scrn = DefaultScreen(dpy);
	int dpth = XDefaultDepth(dpy, scrn);
	Window win = DefaultRootWindow(dpy);
	/* Create the pixmaps accordingly		       *
	 * All the pixmaps MUST have the same height and width */

	XpmAttributes xpmattributes;
	xpmattributes.depth = dpth;
	xpmattributes.valuemask = XpmSize | XpmDepth;
	XpmCreatePixmapFromData(dpy, win, icon_data, &SiagIcon, &SiagMask,
				&xpmattributes);
	Width = xpmattributes.width;
	Height = xpmattributes.height;
	
	/* Now tell the window manager what the icon is */
	hints = XAllocWMHints();
	hints->flags = IconPixmapHint | IconMaskHint;
	hints->icon_pixmap = SiagIcon;
	hints->icon_mask = SiagMask;
	XSetWMHints(dpy, XtWindow(toplevel), hints);
	XFree(hints);
}
