/*
   Copyright (C) 1999  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "xfonts.h"	/* from common */
#include <X11/xpm.h>

#include "ImageP.h"

#define offset(field) XtOffsetOf(ImageRec, image.field)
static XtResource resources[] = {
	{
		XtNbitmap,	/* name */
		XtCBitmap,	/* class */
		XtRPixmap,		/* type */
		sizeof(Pixmap),	/* size */
		offset(bitmap),		/* offset */
		XtRImmediate,		/* default_type */
		(XtPointer) NULL	/* default_addr */
	}
};
#undef offset

/* methods */
static void Realize();
static void Redisplay();
static void Destroy();
static void Resize();
static Boolean SetValues();

/* actions */
static void ImageAction(Widget, XEvent *, String *, Cardinal *);

static XtActionsRec actions[] =
{
	{"image", ImageAction},
};

/* translations */
static char translations[] =
"<Key>:		image()\n";

ImageClassRec imageClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Image",
    /* widget_size		*/	sizeof(ImageRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	NULL,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	translations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* image fields */
    /* empty			*/	0
  }
};

WidgetClass imageWidgetClass = (WidgetClass)&imageClassRec;

static void ImageAction(Widget w, XEvent *event, String *params, Cardinal *n)
{
	;
}

/* ---
*/
static Pixmap scale_pixmap(Display *dpy, GC gc, Pixmap old,
			unsigned int neww, unsigned int newh)
{
        Pixmap new;
        unsigned int x, y, ox, oy;
        unsigned long pixel;
        Window root;
        unsigned int oldw, oldh, border, depth;
        XImage *im_in, *im_out;

        if (old == None) return None;

        XGetGeometry(dpy, old, &root, &x, &y, &oldw, &oldh,
                        &border, &depth);

        new = XCreatePixmap(dpy, root, neww, newh, depth);
        if (new == None) return None;

	if (neww == oldw && newh == oldh) {
		/* just copy the old pixmap */
		XCopyArea(dpy, old, new, gc, 0, 0, oldw, oldh, 0, 0);
		return new;
	}

        im_in = XGetImage(dpy, old, 0, 0, oldw, oldh, ~0, ZPixmap);
        im_out = XGetImage(dpy, new, 0, 0, neww, newh, ~0, ZPixmap);

        for (y = 0; y < newh; y++) {
                oy = y*oldh/newh;
                for (x = 0; x < neww; x++) {
                        ox = x*oldw/neww;
                        pixel = XGetPixel(im_in, ox, oy);
                        XPutPixel(im_out, x, y, pixel);
                }
        }

        XPutImage(dpy, new, gc, im_out, 0, 0, 0, 0, neww, newh);
	XDestroyImage(im_in);
	XDestroyImage(im_out);

        return new;
}

#define superclass (&coreClassRec)
static void Realize(Widget w, XtValueMask *valueMask,
		XSetWindowAttributes *attributes)
{
	unsigned long valuemask = 0;
	XGCValues values;
	ImageWidget iw = (ImageWidget)w;

	(*superclass->core_class.realize)(w, valueMask, attributes);
	iw->image.gc = XCreateGC(XtDisplay(w), XtWindow(w), valuemask, &values);
	iw->image.bg = None;
}

static void Destroy(Widget w)
{
	ImageWidget iw = (ImageWidget)w;
	XFreeGC(XtDisplay(w), iw->image.gc);
}

static void Redisplay(Widget w, XExposeEvent *event, Region r)
{
	ImageWidget iw = (ImageWidget)w;

	if (iw->image.bg == None) Resize(w);
	if (iw->image.bg == None) return;
	XCopyArea(XtDisplay(w), iw->image.bg, XtWindow(w), iw->image.gc,
		0, 0, iw->core.width, iw->core.height, 0, 0);
}

static void Resize(Widget w)
{
	unsigned int x, y, ow, oh, nw, nh, brd, dpt;
	Pixmap op;
	Window root;
	ImageWidget aw = (ImageWidget) w;

	op = aw->image.bitmap;
	XGetGeometry(XtDisplay(w), op, &root,
		&x, &y, &ow, &oh, &brd, &dpt);
	nw = aw->core.width;
	nh = aw->core.height;

	if (XtIsRealized(w)) {
		Pixmap oldbg = aw->image.bg;
		aw->image.bg = scale_pixmap(XtDisplay(w),
			aw->image.gc, aw->image.bitmap, nw, nh);
		if (oldbg != None)
			XFreePixmap(XtDisplay(w), oldbg);
	} else {
		aw->image.bg = None;
	}
}

static Boolean SetValues(Widget current, Widget request, Widget new)
{
	Boolean do_redisplay = True;

	Resize(new);

	return do_redisplay;
}

