/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: main.c,v 1.5 1998/08/21 02:52:49 lance Exp $ */
#include <stdio.h>

#include "data.h"
#include "xwin.h"
#define DEBUG 0

extern void initialize_Plot_struct(Plot *plot); /* see data.h for Plot*/
extern void get_options(int argc, char **argv,Plot *plot);
extern void get_infilenames(int argc, char **argv,Plot *plot);
extern void read_in_data(Plot *plot, int argc, const char *argv0);
extern void make_labels(Plot *plot);
extern void set_options(int *Xt_optcount,char ***Xt_options,
			int *Qp_optcount,char ***Qp_options,
			  int argc, char **argv);
extern void init_windows(int argc, char **argv, PlotXwins *win,Plot *plot);
extern void malloc_scale_and_stuff(Plot *plot);
extern void init_colors(PlotXwins *win, Plot *plot);
extern void make_default_plots_list(Plot *plot);
extern void add_count_field(Plot *plot, int lenght);
extern int  add_plots_list(Plot *plot, const char *list, int plot_Options);
extern void check_plots(Plot *plot);
extern void setup_rubber_bands(PlotXwins *win,Plot *plot);
extern void do_event_loop(PlotXwins *win,Plot *plot);
extern void draw_plot(PlotXwins *win, Plot *plot);
#if(DEBUG)

static void debug(Plot *plot)
{
  int i;
  fprintf(stderr,"\nplot->flag = %d\n",plot->flag);
  fprintf(stderr,"plot->skip_lines = %d\n\n",plot->skip_lines);
  fprintf(stderr,"PLOTS\nplot->num_plots  = %d\n\n",plot->num_plots);
  for(i=0;i<plot->num_plots;i++)
    {
      fprintf(stderr,"plot->list[%d][X] = %d\n",
	    i,plot->list[i][X]);
      fprintf(stderr,"plot->min[%d] = %g\n",
	      plot->list[i][X],plot->min[plot->list[i][X]]);
      fprintf(stderr,"plot->max[%d] = %g\n",
	      plot->list[i][X],plot->max[plot->list[i][X]]);
      fprintf(stderr,"plot->list[%d][Y] = %d\n",
	    i,plot->list[i][Y]);
      fprintf(stderr,"plot->min[%d] = %g\n",
	      plot->list[i][Y],plot->min[plot->list[i][Y]]);
      fprintf(stderr,"plot->max[%d] = %g\n",
	      plot->list[i][Y],plot->max[plot->list[i][Y]]);
      fprintf(stderr,"plot->plot_opt[%d]= %d\n\n",
	    i,plot->plot_opt[i]);
    }
  if(plot->infiles[0] != NULL)
    fprintf(stderr,"FILES\n");
  for(i=0;plot->infiles[i] != NULL;i++)
      fprintf(stderr,"plot->infiles[%d] = %s\n",i,plot->infiles[i]);
}
#endif

int main(int argc, char** argv)
{
  Plot      plot;
  PlotXwins win;
  char **Xt_options = NULL;
  int Xt_optcount = 0;
  char **Qp_options = NULL;
  int Qp_optcount = 0;

  initialize_Plot_struct(&plot);
  set_options(&Xt_optcount,&Xt_options,&Qp_optcount,&Qp_options,
	      argc, argv);
  get_options(Qp_optcount,Qp_options,&plot); /* quickplot options */
  get_infilenames(Qp_optcount,Qp_options,&plot);
  read_in_data(&plot,argc,argv[0]);/* and set up Plot struct part way */
  if(plot.num_plots < 1 && plot.dim > 1)
    make_default_plots_list(&plot);
  if(plot.dim == 1)
    {
      /* have just one field. make another field to plot against */
      add_count_field(&plot, plot.num_points[0]);
      if(plot.num_plots < 1)
	add_plots_list(&plot,"0 1",plot.flag);
    }
  make_labels(&plot);
  check_plots(&plot);

#if(DEBUG)
  debug(&plot);
#endif
  init_windows(Xt_optcount,Xt_options,&win,&plot);
  malloc_scale_and_stuff(&plot);
  init_colors(&win,&plot);
  setup_rubber_bands(&win,&plot);
  draw_plot(&win,&plot);

  do_event_loop(&win,&plot);

  XDestroyWindow(win.display, win.plotwin);
  XCloseDisplay(win.display);

  return 0;
}
