/* 
   Declarations for Julian date routines.

   Modified BLP 8/28/95, 9/26/95 for PSPP.
 */

#if !julcal_h
#define julcal_h 1

#include <time.h>

#define JUL_ROME 2299161L
#define JUL_ENGLAND 2361222L

/* Value returned by juldnj for 14 Oct 1582. */
extern long julian_offset;

long juldnj (struct tm *bdt, long Transition);
struct tm *julcdj (long JD, long Transition);

#define unjul(JUL)						\
	julcdj ((JUL / 60. / 60. / 24.) + julian_offset, 0)

#endif /* !julcal_h */
