/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */



#define START_FUNC               1

struct prefs
{
    GdkColor bgcolor, gridcolor, axiscolor;
    
    gboolean showvgrid, showhgrid, showlegend;
    gboolean showleft, showright, showtop, showbottom, showxy;
    gboolean lefttitle, righttitle, toptitle, bottomtitle;
    gboolean trigunit, calcmode, errappend;
};


enum {
	CALCMODE_APPEND,
	CALCMODE_SELECT,
	CALCMODE_CLEAR
};



#define PREFS_DEFAULT_BGCOLOR     "white"
#define PREFS_DEFAULT_GRIDCOLOR   "LightBlue"
#define PREFS_DEFAULT_AXISCOLOR   "gray"

#define PREFS_DEFAULT_SHOWVGRID   1
#define PREFS_DEFAULT_SHOWHGRID   1
#define PREFS_DEFAULT_SHOWLEGEND  1

#define PREFS_DEFAULT_SHOWLEFT    1
#define PREFS_DEFAULT_SHOWRIGHT   1
#define PREFS_DEFAULT_SHOWTOP     1
#define PREFS_DEFAULT_SHOWBOTTOM  1
#define PREFS_DEFAULT_SHOWXY      1

#define PREFS_DEFAULT_LEFTTITLE   1
#define PREFS_DEFAULT_RIGHTTITLE  0
#define PREFS_DEFAULT_TOPTITLE    1
#define PREFS_DEFAULT_BOTTOMTITLE 1

#define PREFS_DEFAULT_TRIGUNIT   MP_UNIT_RADIAN
#define PREFS_DEFAULT_CALCMODE	 CALCMODE_SELECT

/* These defaults don't have preference items associated with them. They may in the future. */
#define PREFS_DEFAULT_WINDOW_X   500
#define PREFS_DEFAULT_WINDOW_Y   572


/* Stuff */

#define eoln                    '\n'
#define comment                 '#'

/* Prototypes */

extern void defaults  (void);
extern int prefs_save (void);
extern int prefs_read (void);
extern void reset_flags (void);

extern struct prefs prf;
