/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */



#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#ifdef HAVE_IMLIB
#include <gdk_imlib.h>
#endif

#include "gtkplot.h"
#include "gtkplotlayout.h"
#include "gtkplotps.h"
#include "gtksheet.h"

#include "app.h"
#include "version.h"
#include "callbacks.h"
#include "dialogs.h"
#include "mathparsesym.h"
#include "mathparse.h"
#include "prefs.h"
#include "curvefit.h"
#include "print.h"


extern GtkWidget *active_plot;
extern GtkWidget *window1, *ctlwin;
extern GtkWidget *layout;
extern GtkWidget *canvas;
extern GtkWidget *opmenu;
extern func_thing *formn, *currform;
extern GtkWidget *edit, *entry2, *entry3, *entry4, *entry6, *entry7, *entry8, *entry9;
extern GtkWidget *errlab;
extern gboolean PrintOpen;
extern gint nbrfuncs, nbrrealfuncs;
extern func_thing ** funcs;
extern int yyparse ();
extern struct mp_stack **entryidx[2][2];
extern short flagend, initial;
extern char *c;
extern short parseerr;
extern func_thing *formn;
extern double rangexmi, rangeymi, rangexma, rangeyma, majorticks_h, majorticks_v, minorticks_h, minorticks_v;

extern void set_error (void);


struct mp_stack *rangeidx[2][2];


static gdouble eval_entry (GtkWidget *entry);
static void scale_range (gdouble f);
static void update_range_selection_window ();
static void set_new_plot_range (gdouble xmin, gdouble xmax, gdouble ymin, gdouble ymax);


void callback_popup (GtkWidget *w, gpointer *data)
{
    func_thing *data_thing = (func_thing *) data;
    
    if (data_thing)
    {
	if (currform->usable)
	{
	    /* Don't sync the current function if it's been deleted */
	    if (currform->formc != NULL) g_free (currform->formc);
	    currform->formc = gtk_editable_get_chars (GTK_EDITABLE(edit), 0, -1); /* A kind of sync */
	}
	currform = data_thing;
	if (data_thing->formc != NULL)
	    gtk_entry_set_text (GTK_ENTRY(edit), data_thing->formc);
	else
	    gtk_entry_set_text (GTK_ENTRY(edit), "");
    }
}


void callback_button (GtkWidget *w, gpointer data)
{
    extern GtkWidget *edit;
    
    int i;
    double xval=0, yval=0;
    symrec *ptrx = getsym ("x");
    symrec *ptry = getsym ("y");

    /*printf ("%i", formn->index);*/

    if (ptrx)
	xval = ptrx->value.var; 
    if (ptry)
	yval = ptry->value.var;

    if ((GtkWidget *)NULL == edit)
	return;
    
    if (currform != 0)
    {
	if (currform->formc != NULL) g_free (currform->formc);
	currform->formc = gtk_editable_get_chars (GTK_EDITABLE(edit), 0, -1); /* A kind of sync */
    }


    for (i = 0; i != nbrfuncs; ++i)
    {
	func_thing *conv_thing = funcs[i];
	
	if (conv_thing->usable)
	{
	    if (conv_thing->formc != NULL && strcmp (conv_thing->formc, "") != 0)
	    {
		entryidx[0][0] = &conv_thing->entryidx[0][0];
		entryidx[0][1] = &conv_thing->entryidx[0][1];
		entryidx[1][0] = &conv_thing->entryidx[1][0];
		entryidx[1][1] = &conv_thing->entryidx[1][1];
		
		mp_stack_clean ();
		initial = 1;
		flagend=0;
		c = conv_thing->formc;
		formn = conv_thing;
		
		yyparse ();
		
		if (!parseerr)
		{
		    conv_thing->eqnflag = 1;
		    if (conv_thing->error)
		    {
			free (conv_thing->error);
			conv_thing->error = 0;
		    }
		}
		else
		{
		    conv_thing->eqnflag = 0;
		}
	    }
	    else { conv_thing->eqnflag = 0; }
	    
	    if (conv_thing->eqnflag)
	    {
		gtk_plot_show_dataset (conv_thing->real_dataset);
	    }
	    else
	    {
		gtk_plot_hide_dataset (conv_thing->real_dataset);
	    }
	}
	    parseerr = 0;
    }
    if (ptrx)
	ptrx->value.var = xval;
    if (ptry)
	ptry->value.var = yval;
/*
  h = (char *) malloc (500);
  gtk_label_get (GTK_LABEL(errlab), &h);
*/
    set_error();
    gtk_widget_queue_draw (active_plot);
}


void callback_prefs (GtkWidget *w, gpointer data)
{
    dialog_prefs();
}


void callback_about (GtkWidget *w, gpointer data)
{
    dialog_about();
}


void callback_export (GtkWidget *w, gpointer data)
{
    GtkWidget *filew = gtk_file_selection_new (_("Export graph (Bitmap)"));
    gtk_signal_connect_after (GTK_OBJECT (GTK_FILE_SELECTION (filew)-> ok_button), "clicked", (GtkSignalFunc) callback_export_ok, filew);
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT(filew));
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), "graph.png");
    gtk_widget_show (filew);
}


void callback_export_ok (GtkWidget *w, GtkFileSelection *fs)
{
#ifdef HAVE_IMLIB
    /* Imlib ROCKS! Well it may be a memory hog and as leaky as a collandar, but it could do this in 3 lines. It took about 20 supercryptic lines of lowlevel pixmap code to make an export in graphtool, which only supports pixmap. */
    
    GdkImlibImage *im = gdk_imlib_create_image_from_drawable (GTK_PLOT_LAYOUT(layout)->pixmap, NULL, 0, 0, GTK_PLOT_LAYOUT(layout)->width, GTK_PLOT_LAYOUT(layout)->height);
    gdk_imlib_save_image (im, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)), NULL);
    gtk_widget_destroy (GTK_WIDGET(fs));
    gdk_imlib_kill_image (im);
#endif
}


void callback_export_ps (GtkWidget *w, gpointer data)
{
    GtkWidget *filew = gtk_file_selection_new (_("Export graph (PostScript)"));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)-> ok_button), "clicked", (GtkSignalFunc) callback_export_ps_ok, filew);
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), "graph.ps");
    gtk_widget_show (filew);
}


void callback_export_ps_ok (GtkWidget *w, GtkFileSelection *fs)
{
    gtk_plot_layout_export_ps_with_size(GTK_PLOT_LAYOUT(canvas), gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)), 0, 0, GTK_PLOT_PSPOINTS, 612, 612);
    gtk_widget_destroy (GTK_WIDGET(fs));
}


void callback_print (GtkWidget *w, gpointer data)
{
    if (!PrintOpen)
	gtk_widget_show (create_frmPrint ());
}


void callback_load (GtkWidget *w, gpointer data)
{
    GtkWidget *filew = gtk_file_selection_new (_("Load function set"));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)-> ok_button), "clicked", (GtkSignalFunc) callback_load_ok, filew);
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
    gtk_widget_show (filew);
}


void callback_save (GtkWidget *w, gpointer data)
{
    GtkWidget *filew = gtk_file_selection_new (_("Save function set"));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)-> ok_button), "clicked", (GtkSignalFunc) callback_save_ok, filew);
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
    gtk_widget_show (filew);
}


void callback_load_ok (GtkWidget *w, GtkFileSelection *fs)
{
/* Hmmm... */
#if 0
    int i, len;
    FILE *file = fopen(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)), "r");
    if (file)
    {
	for (i=0; i != MAX_FUNC; ++i)
	{
	    fgets (formc[i], 512, file);
	    len = strlen (formc[i]);
	    if (formc[i][len-1] == '\n') formc[i][len-1] = '\0'; /* gcc complains here if we use NULL */
	}
	fclose (file);
	
	gtk_widget_destroy (GTK_WIDGET(fs));
	
	gtk_entry_set_text (GTK_ENTRY(edit), formc[formn]); /* A kind of sync */
    }
#endif
}

void callback_save_ok (GtkWidget *w, GtkFileSelection *fs)
{
/* Hmmm */
#if 0
    int i;
    FILE *file = fopen(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)), "w");
    
    formn->formc = gtk_entry_get_text (GTK_ENTRY(edit)); /* A kind of sync */
    
    if (file)
    {
	for (i=0; i != nbrfuncs; ++i)
	{
	    if (funcs[i]->formc)
	    {
		fprintf (file, "%s\n", funcs[i]->formc);
	    }
	}
	
	fclose (file);
    }
    
    gtk_widget_destroy (GTK_WIDGET(fs));
#endif
}


void callback_source_drag_data_get (GtkWidget *widget,
				    GdkDragContext *context,
				    GtkSelectionData *selection_data,
				    guint info,
				    guint time,
				    guint data)
{
    char string[] = "Some String!";
    gtk_selection_data_set (selection_data, selection_data->target, 8, string, sizeof(string));
}


gboolean callback_keypress (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
    int i;
    func_thing *new_selection=0;
    
    if (event->string[0] == '\r')
    {
	callback_button (NULL, NULL);
    }
    
    
    else if(event->keyval == GDK_Down
	    || event->keyval == GDK_KP_Down
	    || event->keyval == GDK_ISO_Move_Line_Down
	    || event->keyval == GDK_Pointer_Down)
    {
	if (currform->index < nbrrealfuncs-1)
	{
	    for (i=0; i != nbrfuncs; ++i)
	    {
		if (funcs[i]->index == currform->index+1)
		{
		    new_selection = funcs[i];
		}
	    }
	    if (!new_selection) return (FALSE);
	    
	    gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), new_selection->index);
	    callback_popup (NULL, (gpointer)new_selection);
	}
    }
    
    
    else if(event->keyval == GDK_Up
	    || event->keyval == GDK_KP_Up
	    || event->keyval == GDK_ISO_Move_Line_Up
	    || event->keyval == GDK_Pointer_Up)
    {
	if (currform->index > 0)
	{
	    for (i=0; i != nbrfuncs; ++i)
	    {
		if (funcs[i]->index == currform->index-1)
		{
		    new_selection = funcs[i];
		}
	    }
	    if (!new_selection) return (FALSE);
	    gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), new_selection->index);
	    callback_popup (NULL, (gpointer)new_selection);
	}
    }
    else return (FALSE);
    
    /* I have to do this to stop gtk from propagating this event;
       error in gtk? */
    event->keyval = GDK_Right;
    event->state = 0;
    event->length = 0;
    
    return (TRUE);
}


void callback_zoom_in (GtkWidget *w, gpointer data)
{
    double yeah = eval_entry (entry4);
    
    if (yeah == 0)
    {
	/*ERROR Please enter a positive or negative numeric value*/
	return;
    }
    
    scale_range (1 / yeah);
    update_range_selection_window ();
}

void callback_zoom_out (GtkWidget *w, gpointer data)
{
    double yeah = eval_entry(entry4);
    
    if (yeah == 0)
    {
	/*ERROR Please enter a positive or negative numeric value*/
	return;
    }
    
    scale_range (yeah);
    update_range_selection_window ();
}


void callback_scroll_l (GtkWidget *w, gpointer data)
{
    gdouble range = rangexma - rangexmi;
    double yeah = eval_entry (entry2) * range;

    if (yeah == 0)
    {
	/*ERROR Please enter a positive or negative numeric value*/
	return;
    }
    
    
    rangexmi -= yeah;
    rangexma -= yeah;
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);

    update_range_selection_window ();
}


void callback_scroll_r (GtkWidget *w, gpointer data)
{
    gdouble range = rangexma - rangexmi;
    double yeah = eval_entry (entry2) * range;
    
    if (yeah == 0)
    {
	/*ERROR Please enter a positive or negative numeric value*/
	return;
    }
    
    
    rangexmi += yeah;
    rangexma += yeah;
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);

    update_range_selection_window ();
}


void callback_scroll_u (GtkWidget *w, gpointer data)
{
    gdouble range = rangeyma - rangeymi;
    double yeah = eval_entry (entry3) * range;

    if (yeah == 0)
    {
	/*ERROR Please enter a positive or negative numeric value*/
	return;
    }
    
    
    rangeymi += yeah;
    rangeyma += yeah;
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);
    
    update_range_selection_window ();
}


void callback_scroll_d (GtkWidget *w, gpointer data)
{
    gdouble range = rangeyma - rangeymi;
    double yeah = eval_entry (entry3) * range;
    
    if (yeah == 0)
    {
	return;
    }
    
    
    rangeymi -= yeah;
    rangeyma -= yeah;
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);

    update_range_selection_window ();
}


void callback_range_apply (GtkWidget *w, gpointer data)
{
    gdouble xmin = eval_entry (entry6);
    gdouble xmax = eval_entry (entry7);
    gdouble ymin = eval_entry (entry8);
    gdouble ymax = eval_entry (entry9);

#if 0
      if (xmin == 0 || xmax == 0 || ymin == 0 || ymax == 0)
	{
	/*ERROR Please enter a positive or negative numeric value*/
	return;
	}
#endif

    set_new_plot_range (xmin, xmax, ymin, ymax);
}


void callback_zoom_slider (GtkAdjustment *w, gpointer data)
{
    /* put right new values in fields */
    callback_range_apply (NULL, NULL);
}


void callback_ctl_show (GtkWidget *w, gpointer data)
{
    if (!GTK_IS_WIDGET(ctlwin))
    {
	return;
    }
    gtk_widget_show (ctlwin);
}


gboolean callback_ctl_hide (GtkObject *w, gpointer data)
{
    gtk_widget_hide (ctlwin);
    return (TRUE);
}

void callback_label_x (GtkWidget *w, gpointer data)
{
    dialog_label (DIALOG_LABEL_X, _(" X Axis:   "), GTK_PLOT(active_plot)->bottom.title.text);
}


void callback_label_y (GtkWidget *w, gpointer data)
{
    dialog_label (DIALOG_LABEL_Y, _(" Y Axis:   "), GTK_PLOT(active_plot)->left.title.text);
}


void callback_label_title (GtkWidget *w, gpointer data)
{
    dialog_label (DIALOG_LABEL_TITLE, _(" Plot title:   "), GTK_PLOT(active_plot)->top.title.text);
}


void callback_value (GtkWidget *w, gpointer data)
{
    dialog_solve ();
}


gint callback_click_on_titles (GtkWidget *widget, GdkEvent *event, GtkPlotAxis *axis)
{
    if(event->type == GDK_2BUTTON_PRESS)
    {
	GtkPlotAxis *axis2;

	/* Uggh brute force */
	axis2 = gtk_plot_get_axis (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT);
	if (axis2 == axis)
	{
	    callback_label_y (NULL, NULL);
	    return (TRUE);
	}
	axis2 = gtk_plot_get_axis (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM);
	if (axis2 == axis)
	{
	    callback_label_x (NULL, NULL);
	    return (TRUE);
	}
	axis2 = gtk_plot_get_axis (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP);
	if (axis2 == axis) callback_label_title (NULL, NULL);
    }
    return (TRUE);
}

gint callback_click_on_points (GtkWidget *widget, GdkEvent *event, GtkPlotAxis *axis)
{
    return (FALSE);
}

void callback_select_region (GtkWidget *widget, gdouble xmin, gdouble xmax, gdouble ymin, gdouble ymax,
			     gpointer data)
{
    gdouble xrange = rangexma - rangexmi;
    gdouble yrange = rangeyma - rangeymi;

    if (xmin > xmax)
    {
	gdouble tmp = xmin;
	xmin = xmax;
	xmax = tmp;
    }
    if (ymin > ymax)
    {
	gdouble tmp = ymin;
	ymin = ymax;
	ymax = tmp;
    }

    if ((xmax - xmin > 0.02 * xrange) && (ymax - ymin > 0.02 * yrange))
    {
	set_new_plot_range (xmin, xmax, ymin, ymax);
	update_range_selection_window ();
    }
}


static gdouble eval_entry (GtkWidget *entry)
{
    gdouble yeah;
    int err=-1;
    
    entryidx[0][0] = &rangeidx[0][0];
    entryidx[0][1] = &rangeidx[0][1];
    entryidx[1][0] = &rangeidx[1][0];
    entryidx[1][1] = &rangeidx[1][1];
    formn=0; /* This is a single expression - not a function */

    c = gtk_entry_get_text (GTK_ENTRY(entry));
    mp_stack_clean ();
    initial=1;
    flagend=0;
    
    yyparse();
    if (parseerr) return (0);
    
    yeah = mp_eval_exp (0, &err);
    if (err != -1) return (0);
    
    mp_fix_stack();

    return (yeah);
}


static void scale_range (gdouble f)
{
    gdouble xrange, xcenter, yrange, ycenter;

    xrange = rangexma - rangexmi;
    xcenter = rangexmi + xrange / 2.0;
    xrange *= f;
    rangexmi = xcenter - xrange / 2.0;
    rangexma = xcenter + xrange / 2.0;
    
    yrange = rangeyma - rangeymi;
    ycenter = rangeymi + yrange / 2.0;
    yrange *= f;
    rangeymi = ycenter - yrange / 2.0;
    rangeyma = ycenter + yrange / 2.0;

    majorticks_h *= f;
    minorticks_h *= f;
    majorticks_v *= f;
    minorticks_v *= f;

    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);
    gtk_plot_axis_set_ticks(GTK_PLOT(active_plot), GTK_ORIENTATION_HORIZONTAL, majorticks_h, minorticks_h);
    gtk_plot_axis_set_ticks(GTK_PLOT(active_plot), GTK_ORIENTATION_VERTICAL, majorticks_v, minorticks_v);
}


static void update_range_selection_window ()
{
    char ascii[32];

    sprintf (ascii, "%g", rangexmi);
    gtk_entry_set_text (GTK_ENTRY(entry6), ascii);
    sprintf (ascii, "%g", rangexma);
    gtk_entry_set_text (GTK_ENTRY(entry7), ascii);
    sprintf (ascii, "%g", rangeymi);
    gtk_entry_set_text (GTK_ENTRY(entry8), ascii);
    sprintf (ascii, "%g", rangeyma);
    gtk_entry_set_text (GTK_ENTRY(entry9), ascii);
    
    gtk_widget_queue_draw (layout);

    usleep (500); /* Delay a little in case the user is holding down the key shortcut */
}

static void set_new_plot_range (gdouble xmin, gdouble xmax, gdouble ymin, gdouble ymax)
{
    rangexmi = xmin;
    rangexma = xmax;
    rangeymi = ymin;
    rangeyma = ymax;
    
    majorticks_v = (rangeyma - rangeymi) / 10;
    minorticks_v = (rangeyma - rangeymi) / 20;
    majorticks_h = (rangexma - rangexmi) / 10;
    minorticks_h = (rangexma - rangexmi) / 20;
    
    gtk_plot_set_range (GTK_PLOT(active_plot), rangexmi, rangexma, rangeymi, rangeyma);
    gtk_plot_axis_set_ticks(GTK_PLOT(active_plot), GTK_ORIENTATION_HORIZONTAL, majorticks_h, minorticks_h);
    gtk_plot_axis_set_ticks(GTK_PLOT(active_plot), GTK_ORIENTATION_VERTICAL, majorticks_v, minorticks_v);
    gtk_widget_queue_draw (layout);
}
