/*  This file adapted from Spruce
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>

#include <gtk/gtk.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "about.h"


static void set_notebook_tab (GtkWidget *notebook, gint page_num, GtkWidget *widget);

/* FONTS */
#define HELVETICA_20_BFONT "-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*"
#define HELVETICA_14_BFONT "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"
#define HELVETICA_12_BFONT "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_12_FONT  "-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_10_FONT  "-adobe-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
#define CREDITS_FONT       "-misc-fixed-medium-r-normal--13-120-75-75-c-70-iso8859-1"

#define ABOUT_DEFAULT_WIDTH               100
#define ABOUT_MAX_WIDTH                   600
#define LINE_SKIP                          4

static gchar Ver[]    = "GtkGraph %s - Graphing calculator for X";

/* external variables */

gchar *get_credits()
{
   static gchar credits[] =
"\
       Main Programming: Aaron Lehmann \n\
                         <aaronl@vitelus.com>\n\n\
 Additional Programming: Peter sterlund\n\
                         Landon Bradshaw\n\n\
    Third Party Widgets: Adrian Feiguin\n\n\
           Translations: Henri Binsztok\n\
                         Mitsuru Oka\n\n\
               Web Site: Aaron Lehmann\n\
                         <aaronl@vitelus.com>\n\n\
               Graphics: Your name could be here ;-)\n\n\
          Documentation: Your name could be here ;-)\
";

   
   return (gchar*) credits;
}

GtkWidget* create_frmAbout ()
{
    GtkWidget *fixed;
    GtkWidget *cmdAboutClose;
    GtkWidget *notebook;
    GtkWidget *fixed1;
    GtkWidget *frame;
    GtkWidget *lblTitle;
    GtkWidget *lblCopyright;
    GtkWidget *scrolledwindow;
    GtkWidget *txtCredits;
    GtkWidget *lblCredits;
    GtkWidget *frmAbout;
    GdkFont   *fixed_font;
    GtkAdjustment *adj;
    
    char version [50]; 
    
    frmAbout = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_widget_set_name (frmAbout, "frmAbout");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "frmAbout", frmAbout);
    gtk_widget_set_usize (frmAbout, 482, 402);
    gtk_window_set_title (GTK_WINDOW (frmAbout), _("About GtkGraph"));
    gtk_window_set_policy (GTK_WINDOW (frmAbout), FALSE, FALSE, FALSE);
    gtk_signal_connect (GTK_OBJECT (frmAbout), "destroy",
			GTK_SIGNAL_FUNC (on_frmAbout_destroy),
			GTK_OBJECT (frmAbout));
    
    gtk_widget_realize(frmAbout);
    
    fixed = gtk_fixed_new ();
    gtk_widget_set_name (fixed, "fixed");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "fixed", fixed);
    gtk_widget_show (fixed);
    gtk_container_add (GTK_CONTAINER (frmAbout), fixed);
    
    cmdAboutClose = gtk_button_new_with_label (_("Close"));
    gtk_widget_set_name (cmdAboutClose, "cmdAboutClose");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "cmdAboutClose", cmdAboutClose);
    gtk_widget_show (cmdAboutClose);
    gtk_fixed_put (GTK_FIXED (fixed), cmdAboutClose, 384, 358);
    gtk_widget_set_uposition (cmdAboutClose, 384, 358);
    gtk_widget_set_usize (cmdAboutClose, 88, 36);
    GTK_WIDGET_SET_FLAGS (cmdAboutClose, GTK_CAN_DEFAULT);
    gtk_widget_grab_focus (cmdAboutClose);
    gtk_widget_grab_default (cmdAboutClose);
    gtk_signal_connect (GTK_OBJECT (cmdAboutClose), "clicked",
			GTK_SIGNAL_FUNC (on_cmdAboutClose_clicked),
			GTK_OBJECT(frmAbout));
    
    notebook = gtk_notebook_new ();
    gtk_widget_set_name (notebook, "notebook");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "notebook", notebook);
    gtk_widget_show (notebook);
    gtk_fixed_put (GTK_FIXED (fixed), notebook, 8, 8);
    gtk_widget_set_uposition (notebook, 8, 8);
    gtk_widget_set_usize (notebook, 466, 342);
    
    fixed1 = gtk_fixed_new ();
    gtk_widget_set_name (fixed1, "fixed1");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "fixed1", fixed1);
    gtk_widget_show (fixed1);
    gtk_container_add (GTK_CONTAINER (notebook), fixed1);
    
    frame = gtk_frame_new (NULL);
    gtk_widget_set_name (frame, "frame");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "frame", frame);
    gtk_widget_show (frame);
    gtk_fixed_put (GTK_FIXED (fixed1), frame, 32, 12);
    gtk_widget_set_uposition (frame, 32, 12);
    gtk_widget_set_usize (frame, 400, 140);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);

    /*icon = gdk_pixmap_create_from_xpm_d (frmAbout->window, &mask,
      &frmAbout->style->white, spruce_logo_xpm);
      pixmap = gtk_pixmap_new(icon, mask);
      gtk_widget_set_name (pixmap, "pixmap");
      gtk_object_set_data (GTK_OBJECT (frmAbout), "pixmap", pixmap);
      gtk_widget_show (pixmap);
      gtk_container_add (GTK_CONTAINER (frame), pixmap);*/
    
    sprintf (version, _(Ver), VERSION); /* Insert version from config.h */
    
    lblTitle = gtk_label_new (version);
    gtk_widget_set_name (lblTitle, "lblTitle");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "lblTitle", lblTitle);
    gtk_widget_show (lblTitle);
    gtk_fixed_put (GTK_FIXED (fixed1), lblTitle, 8, 160);
    gtk_widget_set_uposition (lblTitle, 8, 160);
    gtk_widget_set_usize (lblTitle, 448, 16);
    
    lblCopyright = gtk_label_new (_("Copyright (C) 1999"));
    gtk_widget_set_name (lblCopyright, "lblCopyright");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "lblCopyright", lblCopyright);
    gtk_widget_show (lblCopyright);
    gtk_fixed_put (GTK_FIXED (fixed1), lblCopyright, 8, 176);
    gtk_widget_set_uposition (lblCopyright, 8, 176);
    gtk_widget_set_usize (lblCopyright, 448, 16);
    
    scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_set_name (scrolledwindow, "scrolledwindow");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "scrolledwindow", scrolledwindow);
    gtk_widget_show (scrolledwindow);
    gtk_fixed_put (GTK_FIXED (fixed1), scrolledwindow, 12, 200);
    gtk_widget_set_uposition (scrolledwindow, 12, 200);
    gtk_widget_set_usize (scrolledwindow, 436, 100);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    
    fixed_font = gdk_font_load (CREDITS_FONT);
    
    txtCredits = gtk_text_new (NULL, NULL);
    gtk_widget_set_name (txtCredits, "txtCredits");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "txtCredits", txtCredits);
    gtk_widget_show (txtCredits);
    gtk_container_add (GTK_CONTAINER (scrolledwindow), txtCredits);
    gtk_widget_realize (txtCredits);
    gtk_text_insert (GTK_TEXT (txtCredits), fixed_font, NULL, NULL, _(get_credits()), -1);
    gtk_text_set_point(GTK_TEXT(txtCredits), 0);
    
    
    adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(scrolledwindow));
    gtk_adjustment_set_value (adj, 0);
    
    lblCredits = gtk_label_new (_("Credits"));
    gtk_widget_set_name (lblCredits, "lblCredits");
    gtk_object_set_data (GTK_OBJECT (frmAbout), "lblCredits", lblCredits);
    gtk_widget_show (lblCredits);
    set_notebook_tab (notebook, 0, lblCredits);
    
    return frmAbout;
}

void on_frmAbout_destroy (GtkObject *object, gpointer user_data)
{
    GtkWidget *p = GTK_WIDGET(user_data);
    gtk_widget_destroy(p);
}

void on_cmdAboutClose_clicked (GtkButton *button, gpointer user_data)
{
    GtkWidget *p = GTK_WIDGET(user_data);
    gtk_widget_destroy(p);
}

/* This is an internally used function to set notebook tab widgets. */
static void set_notebook_tab (GtkWidget *notebook, gint page_num, GtkWidget *widget)
{
    GtkNotebookPage *page;
    GtkWidget *notebook_page;
    page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
    notebook_page = page->child;
    gtk_widget_ref (notebook_page);
    gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
    gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
			      widget, page_num);
    gtk_widget_unref (notebook_page);
}
