/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* callback_menu.h  by Paul Wilkins 3/15/97 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "menu.h"
#include "lcd.h"
#include "mode.h"
#include "help.h"
#include "complex.h"
#include "number.h"

gint delete_event(GtkWidget *w, GdkEvent *e, gpointer d){
   return FALSE;  /* will call our destroy function */
}

void destroy(GtkWidget *widget, gpointer data){
   gtk_main_quit();
}

/* quit the program */
void quitCB(gpointer data){
   gtk_main_quit();
}

/* clear the stack */
void clearCB(gpointer data){

   clearLCD();

   /* refresh the display */
   redrawLCD();

}


void licenseCB(gpointer data){
   license_popup();
}

void helpCB(gpointer data){
   help_popup();
}


/* change the base we use to display the numbers */
void baseCB(gpointer clientData){

   setBaseMode((int)clientData);

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}

void baseToggleCB(GtkWidget *widget, gpointer data){
   if(GTK_TOGGLE_BUTTON(widget)->active){
      baseCB(data);
   }
}

/* change the radix mode we use to display the numbers */
void radixCB(gpointer clientData){
   
   setRadixMode((int)clientData);

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}

void radixToggleCB(GtkWidget *widget, gpointer data){
   if(GTK_TOGGLE_BUTTON(widget)->active){
      radixCB(data);
   }
}

/* change the coordinate mode we use to display the numbers */
void cmodeCB(gpointer clientData){
   
   switch((int)clientData){
      case RECTANGULAR:
         setPolarMode(RECTANGULAR);
         break;
      case POLAR:
         setPolarMode(POLAR);
         break;
      default:
         fprintf(stderr, "Error: radixCB: i shouldn't get here\n");
         exit(0);
   }

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}

void cmodeToggleCB(GtkWidget *widget, gpointer data){
   if(GTK_TOGGLE_BUTTON(widget)->active){
      cmodeCB(data);
   }
}

/* change the display mode we use to display the numbers */
void dmodeCB(gpointer clientData){
   
   setLCDDispMode((int)clientData);

   /* refresh the display */
   redrawLCD();
}

void dmodeToggleCB(GtkWidget *widget, gpointer data){
   if(GTK_TOGGLE_BUTTON(widget)->active){
      dmodeCB(data);
   }
}
