/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

 /*
  * Geometry Routines
  * 
  * Geometry Supercomputer Project
  * 
  * ROUTINE DESCRIPTION:  Save a skel object to a file.
  * 
  */

#include "skelP.h"

Skel *
SkelFSave(Skel *s, FILE *f)
{
	int i, j, d;
	float *p;
	int *vp;
	Skline *l;
	register ColorA *c;

	/* This one just saves in ASCII format */

	if(s == NULL || f == NULL)
		return NULL;

	d = s->geomflags & VERT_4D ? s->dim : s->dim-1;
	if (s->geomflags & VERT_4D)
	    fprintf(f, "4");
	fprintf(f, s->dim==4 ? "SKEL" : "nSKEL %d", d);
	fprintf(f, "\n%d %d\n\n", s->nvert, s->nlines);

	for(i = 0, p = s->p; i < s->nvert; i++, p += s->dim) {
	    fputnf(f, d, p, 0);
	    fputc('\n', f);
	}
	fputc('\n', f);

	for(i = 0, l = s->l; i < s->nlines; i++, l++) {
	    fprintf(f, "%d\t", l->nv);
	    for(j = 0, vp = &s->vi[l->v0]; j < l->nv; j++, vp++)
		fprintf(f, "%d ", *vp);
	    if(l->nc > 0) {
		fputc('\t', f);
		fputnf(f, 4, &s->c[l->c0].r, 0);
	    }
	    fputc('\n', f);
	}
	return ferror(f) ? NULL : s;
}
