/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bezierP.h"

/*
 * evert patch by transposing control points.
 * If mesh has been computed, also call MeshEvert
 * Next time mesh is computed, its normals will be correct.
 */
Bezier *
BezierEvert( bezier )
Bezier *bezier;
{
    register int index0, index1, i,j,k;
    float	tmp;

#ifdef FOO
    /* index0 will be linear index of control point... */
    for( i = 0; i< bezier->degree+1; ++i)
        for( j = i+1; j< bezier->degree+1; ++j)
		{
		/* ... compute index1 for transpose control point */
		index1 = bezier->dimn * (j * (bezier->degree+1) + i);
		index0 = bezier->dimn * (i * (bezier->degree+1) + j);
        	for( k = 0; k< bezier->dimn; ++k)
		    {
		    tmp = bezier->CtrlPnts[index0+k];
		    bezier->CtrlPnts[index0+k] = bezier->CtrlPnts[index1+k];
		    bezier->CtrlPnts[index1+k] = tmp;
		    }
		}
#endif
    if (bezier->flag & BEZ_REMESH || bezier->mesh == NULL)
	BezierReDice(bezier);
    MeshEvert(bezier->mesh);

    return bezier;
}

