
#import "ToolPanelDel.h"
#import "GVApp.h"

#import "../common/transform.h" 
// Need the ../common otherwise get the library header file

@implementation ToolPanelDel

- init
{
  [super init];
  lastMode = TOOL_ROT;
  [NXApp loadNibSection:"ToolPanel.nib" owner:self withNames:NO];
  [NXApp makeKeyResponderFor:toolPanel];
  [toolPanel setBecomeKeyOnlyIfNeeded:YES];
  return self;
}

- awakeFromNib
{
  [translate setTag:TOOL_TRANS];
  [rotate setTag:TOOL_ROT];
  [camFly setTag:TOOL_FLY];
  [camOrbit setTag:TOOL_ORBIT];
  [camZoom setTag:TOOL_ZOOM];
  [geomScale setTag:TOOL_SCALE];

  [stop setTag:ACTION_STOP];
  [center setTag:ACTION_CENTER];
  [lookAt setTag:ACTION_LOOK];
  [reset setTag:ACTION_RESET];
  return self;
}

- display
{
  struct panel *p=&panels[P_TOOL];
  [self setCenterField];
  [self setTargetField];
  if(p->x0>=0) [toolPanel moveTo:p->x0 :p->y0];
  p->x0 = -1;
  if(p->shown) {
    [self event_mode];
    [self setCenterField];
    [self setTargetField];
    [self setSpace];
    [toolPanel orderFront:self];   
  }
  else [toolPanel close];
  return self;
}

- editMode:sender
{
  if((uistate.lights_shown==0)!=([[sender selectedCell] tag]==0))
    light_edit_mode([[sender selectedCell] tag]);
  return self;
}

- lightEdit
{
  if(uistate.lights_shown) {
    [toolPanelMatrix selectCellWithTag:TOOL_ROT];
    [self setCenterField];  
  }
  else {
    [toolPanelMatrix selectCellWithTag:lastMode];
    gv_event_mode(uistate.modenames[lastMode]); 
  }
  [self setCenterField];
  [self setTargetField];
  return self;
}

- selectTool:sender
{  
  if(uistate.lights_shown&&([[sender selectedCell] tag]!=TOOL_ROT)) {
    NXBeep();
    [toolPanelMatrix selectCellWithTag:TOOL_ROT];
    return self;
  }
  gv_event_mode(uistate.modenames[[[sender selectedCell] tag]]); 
  return self;
}

- doAction:sender
{
  if(uistate.lights_shown) {
    NXBeep();
    return self;
  }

  switch([[sender selectedCell] tag]) {
  case ACTION_STOP:
    drawer_stop(NOID);   
    break;
  case ACTION_LOOK:
    gv_look(uistate.targetid, CAMID(uistate.mousefocus));
    break;
  case ACTION_CENTER:
    drawer_center(uistate.targetid); 
    break;
  case ACTION_RESET:
    drawer_center(NOID); 
    break;
  }
  return self;
}

- target:sender
{
  int metaid=drawer_name2metaid((char *)[sender stringValue]);
  if(metaid==NOID) NXBeep();
  gv_ui_target(metaid, IMMEDIATE);
  return self;
}

- center:sender
{
  int metaid=drawer_name2metaid((char *)[sender stringValue]);
  if(metaid==NOID) {
    NXBeep();
    gv_ui_center(uistate.centerid);
  }
  else gv_ui_center(metaid);
  return self;
}

- targetF {return targetF;} 
- centerField {return centerField;}
- toolMatrix {return toolPanelMatrix;}
- toolPanel {return toolPanel;}

- action:(int)val
{
// make the action val blink? 
//  [[actionMatrix findCellWithTag:val] performClick:self];
  return self;
}

- event_mode
{
  if(!uistate.lights_shown) lastMode = uistate.mode_current;
  [toolPanelMatrix selectCellWithTag:uistate.mode_current];
  return self;
}

- setCenterField
{
  if(uistate.lights_shown) 
    [centerField setStringValue:"world"];
  else
    [centerField setStringValue:drawer_id2name(uistate.centerid)];
  [centerField update];
  return self;
}

- setTargetField
{
  char buf[32];
  if(uistate.lights_shown) {
    if(uistate.current_light==0) sprintf(buf,"ambient");
    else sprintf(buf,"light %d",uistate.current_light);
    [targetF setStringValue:buf];
  }
  else [targetF setStringValue:drawer_id2name(uistate.targetid)];
  [targetF update];
  return self;
}

- geometry:sender
{
  int i;
  if([[sender selectedCell] tag]!=(uispace(spaceof(WORLDGEOM)))) {
    switch ([[sender selectedCell] tag]) {
    default:
    case EUCLIDEAN:
      i = EUCLIDEAN_KEYWORD;
      break;
    case HYPERBOLIC:
      i = HYPERBOLIC_KEYWORD;
      break;
    case SPHERICAL:
      i = SPHERICAL_KEYWORD;
      break;
    }
    gv_space(i);
  }
  return self;
}

- setSpace
{
  switch (uispace(spaceof(WORLDGEOM))) {
  default:
  case EUCLIDEAN:
    [geometry setTitle:"Euclidean"];    
    break;
  case HYPERBOLIC:
    [geometry setTitle:"Hyperbolic"];    
    break;
  case SPHERICAL:
    [geometry setTitle:"Spherical"];    
    break;
  }
  return self;
}

- model:sender
{
  int i=[[sender selectedCell] tag];
  gv_hmodel(real_id(FOCUSID), hmodelkeyword("ModelBrowserProc", i));
  return self;
}

- setModel
{
  DView *dv;
  if((dv = (DView *)drawer_get_object(FOCUSID)) && ISCAM(dv->id))
  switch (dv->hmodel) {
  default:
  case EUCLIDEAN:
    [model setTitle:"Virtual"];    
    break;
  case HYPERBOLIC:
    [model setTitle:"Projective"];    
    break;
  case SPHERICAL:
    [model setTitle:"Conformal"];    
    break;
  }
  return self;
}

- close
{
  ui_showpanel(P_TOOL,0);
  return self;
}

- window {return toolPanel;}

@end
