/*********************************************************************

** This library uses the netcdf - version 2.4.3 which is
** Copyright 1993-1997 University Corporation for Atmospheric Research/Unidata

** The netcdf library is provided as per the terms of the
** UCAR/Unidata license

** See interface/netcdf-2.4.3/COPYRIGHT for the full notice

********************************************************************/

/* $Id: diskio_struct.h,v 1.2 1997/07/26 00:12:00 venkat Exp $ */
/* $Log: diskio_struct.h,v $
 * Revision 1.2  1997/07/26 00:12:00  venkat
 * Added
 * */

#include "struct_defs.h"



/** 
 	###############################
	 The object structures 
	###############################
**/

struct Gen_Diskio_Type {
 ELEMENT_TYPE
 /* 
    ###########
	Fields to be shown with a showfield 
    ###########
 */
 
 /* Name of file to which interfaced */
 char *filename;

 /* Format of the file - FMT1, Netcdf etc., */
 char *fileformat;

 /* States of the file */
 short is_open;
 short is_writable;
 char accessmode;

 /* Hidden Abstract interface members */
 char *adi; 
 char *coordi;
 /* Hidden count of time step */
 long start_time_index[1];

 /* Backwards compatibility (with disk_out/disk_in) fields */

 float **val; /* Frame of values to be read from file on disk every time step*/
 char **autoSAVEavi; /* The frame of variable interface handles */ 
 int nx; 	    /* The number of such frames read every time step - Is 1 for FMT1 and
		     the same holds for diskio as well at this point */
 int ny;	    /* Number of values in a single frame = number of autoSAVE variable children*/	

 short valsallocated; /* flag- Are the frames allocated ? */
 short append; /* Should data be appended after resetting */

 char **autoSAVEamdi; /* Frame of 3-D Pos metadata interface handles */

 /* The same fields as in disk_in - They hold the 3-D coords of the src element*/
 struct interpol_struct *xpts;
 struct interpol_struct *ypts;
 struct interpol_struct *zpts;

 /* Dummy fields so earlier scripts dont break */
 short flush;
 short leave_open; 
};

struct Gen_Variable_Type {
 ELEMENT_TYPE

 /* The number of values stored */
 int size;
 /* The datatype of the values stored */
 char *datatype;
 /* A specific value as string */
 char *value;
 
 /* input and output fields for messages and basic simulation functionality */
 double input;
 double output;

 /* Hidden Abstract interface members */
 char *avi;
 char *coordi;
 /* Hidden count of time step */
 long start_time_index[1];
};

struct Gen_Metadata_Type {
 ELEMENT_TYPE

 /* The number of attrib vals */
 int size;
 /* The datatype of attrib vals */
 char *datatype; 
 /* A value as string */
 char *value;

 /* Hidden Abstract interface member */
 char *amdi;
};
