/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef angle_h
#define angle_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Classes in charge of angle : given 3 points or a vectrex
class angle_3points:public valeur_c
{
  public:
  point_c * pt1, *pt2, *pt3;
  double origin, arc_length;
    angle_3points (void):valeur_c ()
  {
    classe = VA_AN_3PT;
  }
  angle_3points (liste_elem & lp):valeur_c ()
  {
    unite = DEGRES;
    classe = VA_AN_3PT;
    pt1 = (point_c *) lp.lire (1);
    pt2 = (point_c *) lp.lire (2);
    pt3 = (point_c *) lp.lire (3);
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  void dessine (GdkPixmap * ecran, char force);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
class angle_2vecteurs:public valeur_c
{
  public:
  vecteur_c * v1, *v2;
  angle_2vecteurs (void):valeur_c ()
  {
    classe = VA_AN_2VE;
  }
  angle_2vecteurs (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    unite = DEGRES;
    classe = VA_AN_2VE;
    v1 = (vecteur_c *) lp.lire (1);
    v2 = (vecteur_c *) lp.lire (2);
    init_nom ();
  }
angle_2vecteurs (liste_elem & lp):valeur_c ()
  {
    unite = DEGRES;
    classe = VA_AN_2VE;
    v1 = (vecteur_c *) lp.lire (1);
    v2 = (vecteur_c *) lp.lire (2);
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  void dessine (GdkPixmap * ecran, char force);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};


#endif
