# $Id: format.tcl,v 1.14 1998/08/24 18:33:55 cthulhu Exp $

set borderNames {None Thin Medium  Thick {} Double {} {As is}}
set formatStringTypes {general date time fixed scientific percentage currency all}
set formatStrings(general) {{General 241}}
set formatStrings(date) {{MM/DD/YY 249} {DD/MM/YY 250} \
        {DD-MMM-YY 242} {DD-MMM 243} {MMM-YY 244} }
set formatStrings(time) {{{DD-MMM-YY HH:MM:SS} 247} {{DD-MMM-YY HH:MM} 248}}
set formatStrings(fixed) {{# 128} {#.# 129} {#.## 130} {#.### 131} \
        {#.#### 132} {#.##### 133} {#.###### 134} {#.####### 135}}
set formatStrings(scientific) {{#E## 144} {#.#E## 145} {#.##E## 146} \
        {#.###E## 147} {#.####E## 148} {#.#####E## 149}}
set formatStrings(percentage) {{{# %} 176} {{#.# %} 177} {{#.## %} 178} \
        {{#.### %} 179} {{#.#### %} 180}}
set formatStrings(currency) {{{$ #} 160} {{$ #.#} 161} {{$ #.##} 162}}
set formatStrings(all) {\
        {General 241} \
        {MM/DD/YY 249} {DD/MM/YY 250} \
	{DD-MMM-YY 242} {DD-MMM 243} {MMM-YY 244} \
        {{DD-MMM-YY HH:MM:SS} 247} {{DD-MMM-YY HH:MM} 248} \
        {# 128} {#.# 129} {#.## 130} {#.### 131} \
        {#.#### 132} {#.##### 133} {#.###### 134} {#.####### 135} \
        {#E## 144} {#.#E## 145} {#.##E## 146} {#.###E## 147} \
        {#.####E## 148} {#.#####E## 149} \
        {{# %} 176} {{#.# %} 177} {{#.## %} 178} \
        {{#.### %} 179} {{#.#### %} 180} \
        {{$ #} 160} {{$ #.#} 161} {{$ #.##} 162} \
}

proc applyFontToSelection {f {modtype -1}} {
    source [xxl_library]/globalvars.tcl
    
    if {$cols_selected != ""} {
	SetFont $activeSheet [lindex $f 0] [lindex $f 1] \
	    [lindex $f 2] [lindex $f 3] \
	    [lindex $cols_selected 0] -1 \
	    [lindex $cols_selected 1] -1 \
	    1 $modtype
    } elseif {$rows_selected != ""} {
	SetFont $activeSheet [lindex $f 0] [lindex $f 1] \
	    [lindex $f 2] [lindex $f 3] \
	    -1 [lindex $rows_selected 0] \
	    -1 [lindex $rows_selected 1] \
	    1 $modtype
    } elseif {$currentRange == ""} {
	SetFont $activeSheet [lindex $f 0] [lindex $f 1] \
	    [lindex $f 2] [lindex $f 3] \
	    $activeCellCol $activeCellRow 1
    } else {
        SetFont $activeSheet [lindex $f 0] [lindex $f 1] \
	    [lindex $f 2] [lindex $f 3] \
	    [lindex $currentRange 0] \
	    [lindex $currentRange 1] \
	    [lindex $currentRange 2] \
	    [lindex $currentRange 3] 1 $modtype
    }
}

proc applyFormatToSelection {f} {
    source [xxl_library]/globalvars.tcl
    
    if {$cols_selected != ""} {
	SetFormat $activeSheet $f \
	    [lindex $cols_selected 0] -1 \
	    [lindex $cols_selected 1] -1
    } elseif {$rows_selected != ""} {
	SetFormat $activeSheet $f \
	    -1 [lindex $rows_selected 0] \
	    -1 [lindex $rows_selected 1]
    } elseif {$currentRange == ""} {
        SetFormat $activeSheet $f \
                $activeCellCol $activeCellRow
    } else {
        SetFormat $activeSheet $f \
                [lindex $currentRange 0] \
                [lindex $currentRange 1] \
                [lindex $currentRange 2] \
                [lindex $currentRange 3] 
    }
}

proc applyAlignmentToSelection {f} {
    source [xxl_library]/globalvars.tcl
    
    if {$cols_selected != ""} {
	SetAlignment $activeSheet $f \
	    [lindex $cols_selected 0] -1 \
	    [lindex $cols_selected 1] -1
    } elseif {$rows_selected != ""} {
	SetAlignment $activeSheet $f \
	    -1 [lindex $rows_selected 0] \
	    -1 [lindex $rows_selected 1]
    } elseif {$currentRange == ""} {
        SetAlignment $activeSheet $f \
                $activeCellCol $activeCellRow
    } else {
        SetAlignment  $activeSheet $f \
                [lindex $currentRange 0] \
                [lindex $currentRange 1] \
                [lindex $currentRange 2] \
                [lindex $currentRange 3] 
    }
}

proc applyShadeToSelection {f} {
    source [xxl_library]/globalvars.tcl
    
    if {$cols_selected != ""} {
	SetFill $activeSheet $f \
	    [lindex $cols_selected 0] -1 \
	    [lindex $cols_selected 1] -1 
    } elseif {$rows_selected != ""} {
	SetFill $activeSheet $f \
	    -1 [lindex $cols_selected 0] \
	    -1 [lindex $cols_selected 1]
    } elseif {$currentRange == ""} {
	SetFill $activeSheet $f $activeCellCol $activeCellRow
    } else {
        SetFill $activeSheet \
	    $f \
	    [lindex $currentRange 0] \
	    [lindex $currentRange 1] \
	    [lindex $currentRange 2] \
	    [lindex $currentRange 3] 
    }
}

proc applyBordersToSelection {} {
    source [xxl_library]/globalvars.tcl
    global bordertop borderbottom borderleft borderright

    if {$cols_selected != ""} {
	SetBorders $activeSheet \
	    $bordertop $borderbottom $borderleft $borderright \
	    [lindex $cols_selected 0] -1 \
	    [lindex $cols_selected 1] -1
    } elseif {$rows_selected != ""} {
	SetBorders $activeSheet \
	    $bordertop $borderbottom $borderleft $borderright \
	    -1 [lindex $rows_selected 0] \
	    -1 [lindex $rows_selected 1]
    } elseif {$currentRange == ""} {
        SetBorders $activeSheet \
                $bordertop $borderbottom $borderleft $borderright \
                $activeCellCol $activeCellRow 
    } else {
        SetBorders $activeSheet \
                $bordertop $borderbottom $borderleft $borderright \
                [lindex $currentRange 0] \
                [lindex $currentRange 1] \
                [lindex $currentRange 2] \
                [lindex $currentRange 3] 
    }
    set bordertop 7
    set borderbottom 7
    set borderleft 7
    set borderright 7
}

proc displayFormatToolbar {mother nextone} {
    global fontFamilies fontSizes fontName fontSize borderNames
    global fontNameIndex fontSizeIndex
    global fontBoldIndex fontItalicIndex shadeIndex
    global bordertop borderbottom borderleft borderright
    global formatStrings formatStringTypes
    
    catch {destroy $mother.format}

    frame $mother.format

    frame $mother.format.g1 -relief ridge
    label $mother.format.g1.fontname -bg white -relief sunken \
            -width 30 -textvariable fontName
    bind $mother.format.g1.fontname <Enter> \
	{HelpMessage "Active font name"}
    menubutton $mother.format.g1.fname_pull -image pulldown_bm \
            -menu $mother.format.g1.fname_pull.menu -relief raised
    bind $mother.format.g1.fname_pull <Enter> \
	{HelpMessage "Change font"}
    menu $mother.format.g1.fname_pull.menu 

    set cnt 0
    foreach i $fontFamilies {
        $mother.format.g1.fname_pull.menu add radiobutton -label $i \
                -variable fontNameIndex -value $cnt \
	    -command {set s [setFontName]; applyFontToSelection $s 2}
        incr cnt
    }
    

    
    set fontsize [lindex $fontSizes 2]
    frame $mother.format.g2 -relief ridge
    label $mother.format.g2.fontsize -bg white -relief sunken \
            -width 3 -textvariable fontSize
    bind $mother.format.g2.fontsize <Enter> \
	{HelpMessage "Active font size"}
    menubutton $mother.format.g2.fsize_pull -image pulldown_bm \
            -menu $mother.format.g2.fsize_pull.menu -relief raised
    bind $mother.format.g2.fsize_pull <Enter> \
	{HelpMessage "Change font size"}
    menu $mother.format.g2.fsize_pull.menu 
    set cnt 0
    foreach i $fontSizes {
        $mother.format.g2.fsize_pull.menu add radiobutton -label $i \
                -variable fontSizeIndex -value $cnt \
	    -command {set s [setFontName] ; applyFontToSelection $s 3}
        incr cnt
    }

    
    
    
    frame $mother.format.g3 
    checkbutton $mother.format.g3.bold -image bold_bm -relief ridge \
            -variable fontBoldIndex \
	-command {set s [setFontName] ; applyFontToSelection $s 5}
    bind $mother.format.g3.bold <Enter> \
	{HelpMessage "Set Bold On/Off"}
    
    checkbutton $mother.format.g3.italic -image italic_bm -relief ridge \
            -variable fontItalicIndex \
	-command {set s [setFontName] ; applyFontToSelection $s 4}
    bind $mother.format.g3.italic <Enter> \
	{HelpMessage "Set Italic On/Off"}
    
    frame $mother.format.g35    
    menubutton $mother.format.g35.format -text Format \
            -menu $mother.format.g35.format.formats -relief raised
    bind $mother.format.g35.format <Enter> \
	{HelpMessage "Change data format of current selection"}
    menu $mother.format.g35.format.formats
#     set cnt 0
#     foreach i $formatStrings {
#         $mother.format.g35.format.formats add radiobutton \
#                 -label [lindex $i 0] -value [lindex $i 1] \
#                 -variable formatValue \
#                 -command {applyFormatToSelection $formatValue}
#         incr cnt
#     }
   foreach i $formatStringTypes {
       menu $mother.format.g35.format.formats.$i
       $mother.format.g35.format.formats add cascade \
               -label $i -menu $mother.format.g35.format.formats.$i
       foreach j $formatStrings($i) {
           $mother.format.g35.format.formats.$i add radiobutton \
                   -label [lindex $j 0] -value [lindex $j 1] \
                 -variable formatValue \
	       -command {applyFormatToSelection $formatValue}
       }
   }


    frame $mother.format.g4

    menubutton $mother.format.g4.fill_pull -image shade_bm \
            -menu $mother.format.g4.fill_pull.menu -relief raised
    bind $mother.format.g4.fill_pull <Enter> \
	{HelpMessage "Change fill level of current selection"}
    menu $mother.format.g4.fill_pull.menu 
    foreach i {20 40 50 60 70 80 90 95 100} {
        $mother.format.g4.fill_pull.menu add radiobutton -image gray$i \
                -variable shadeIndex -value $i \
                -command {applyShadeToSelection $shadeIndex}
    }
    menubutton $mother.format.g4.borders_pull -image borders_bm \
            -menu $mother.format.g4.borders_pull.menu -relief raised
    bind $mother.format.g4.borders_pull <Enter> \
	{HelpMessage "Change border style of current selection"}
    menu $mother.format.g4.borders_pull.menu
    foreach i {top bottom left right} {
        menu $mother.format.g4.borders_pull.menu.$i
        

        $mother.format.g4.borders_pull.menu add cascade -label $i \
                -menu $mother.format.g4.borders_pull.menu.$i
        foreach j {7 0 1 2 3 5} {
            $mother.format.g4.borders_pull.menu.$i add radiobutton \
                    -label [lindex $borderNames $j] \
                    -value $j -variable border$i \
                    -command {applyBordersToSelection}
        }
    }

    frame $mother.format.g5 -borderwidth 2 -relief ridge
    radiobutton $mother.format.g5.idef -text Default \
            -variable positionLRC -value 0 \
            -command {applyAlignmentToSelection $positionLRC}
    bind $mother.format.g5.idef <Enter> \
	{HelpMessage "Default alignment"}
    radiobutton $mother.format.g5.ileft -image left_bm \
	-variable positionLRC -value 1 \
	-command {applyAlignmentToSelection $positionLRC}
    bind $mother.format.g5.ileft <Enter> \
	{HelpMessage "Align current selection left"}
    radiobutton $mother.format.g5.icenter -image center_bm \
            -variable positionLRC -value 2 \
            -command {applyAlignmentToSelection $positionLRC}
    bind $mother.format.g5.icenter <Enter> \
	{HelpMessage "Center current selection"}
    radiobutton $mother.format.g5.iright -image right_bm \
            -variable positionLRC -value 3 \
            -command {applyAlignmentToSelection $positionLRC}
    bind $mother.format.g5.iright <Enter> \
	{HelpMessage "Align current selection right"}
    
    $mother.format.g5.idef select
    
    pack $mother.format.g1.fontname $mother.format.g1.fname_pull -side left
    pack $mother.format.g2.fontsize $mother.format.g2.fsize_pull -side left
    pack $mother.format.g3.bold $mother.format.g3.italic -side left
    pack $mother.format.g35.format -side left
    pack $mother.format.g4.fill_pull $mother.format.g4.borders_pull -side left
    pack $mother.format.g5.idef $mother.format.g5.ileft \
            $mother.format.g5.icenter $mother.format.g5.iright -side left
    pack $mother.format.g5 $mother.format.g4 $mother.format.g35 \
            $mother.format.g3 $mother.format.g2 $mother.format.g1 \
            -side right -padx 0.3c
    pack $mother.format -fill x -before $nextone
    set format-show 1
}

# $Log: format.tcl,v $
# Revision 1.14  1998/08/24 18:33:55  cthulhu
# Added tooltips.
#
# Revision 1.13  1998/08/21 19:00:18  cthulhu
# SetFill, SetAlignment, SetBorders, etc are now used with column/row groups
# instead of a column/row at a time. Faster since the multi-column/row handling
# is done in C instead of Tcl.
#
# Revision 1.12  1998/08/06 21:08:31  aml
# Released alpha version of Abacus.
#
# Revision 1.11  1996/11/22 16:29:10  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.10  1996/10/09 13:55:01  aml
# First cut of full print.
#
# Revision 1.9  1996/10/07 12:35:29  aml
# First cut at error handling.
# Date formats are in.
# Fixed problem with blank cell drawing.
#
# Revision 1.8  1996/09/17  15:16:16  aml
# Fixed problems with copying of cells with non-default formats.
# Created printing formats, alignment formats.
# Format toolbar now reflects format of active cell.
#
# Revision 1.7  1996/09/17 14:40:13  aml
# Fixed problems with copying of cells with non-default formats.
# Created printing formats, alignment formats.
# Format toolbar now reflects format of active cell.
#
# Revision 1.6  1996/09/16 18:42:16  aml
# Some performance problems addressed by reducing tag use.
# Several performance problems remain when heavy use is made
# of borders and shading in large spreadsheets.
#
# Revision 1.5  1996/09/15 19:24:16  aml
# Rulling and shading.
# Optionally hide cell borders.
# Works well, but is very slow for large spreadsheets.
#
# Revision 1.4  1996/09/14  23:55:53  aml
# Created cell shading.
#
# Revision 1.3  1996/09/04  14:29:52  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.4  1995/08/10 18:14:21  aml
# Abandoned way to implement individual cell formats.
#
# Revision 1.3  1995/08/10 03:00:49  aml
# Created pull down choice widgets
# Font name and size now work
#
# Revision 1.2  1995/08/09 21:13:23  aml
# Created modular toolbars
# Changes in mouse state machine
# Completed format toolbar
#
# Revision 1.1  1995/08/09 18:36:57  aml
# Initial revision
#


# $Log: format.tcl,v $
# Revision 1.14  1998/08/24 18:33:55  cthulhu
# Added tooltips.
#
# Revision 1.13  1998/08/21 19:00:18  cthulhu
# SetFill, SetAlignment, SetBorders, etc are now used with column/row groups
# instead of a column/row at a time. Faster since the multi-column/row handling
# is done in C instead of Tcl.
#
# Revision 1.12  1998/08/06 21:08:31  aml
# Released alpha version of Abacus.
#
# Revision 1.11  1996/11/22 16:29:10  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.10  1996/10/09 13:55:01  aml
# First cut of full print.
#
# Revision 1.9  1996/10/07 12:35:29  aml
# First cut at error handling.
# Date formats are in.
# Fixed problem with blank cell drawing.
#
# Revision 1.8  1996/09/17  15:16:16  aml
# Fixed problems with copying of cells with non-default formats.
# Created printing formats, alignment formats.
# Format toolbar now reflects format of active cell.
#
# Revision 1.7  1996/09/17 14:40:13  aml
# Fixed problems with copying of cells with non-default formats.
# Created printing formats, alignment formats.
# Format toolbar now reflects format of active cell.
#
# Revision 1.6  1996/09/16 18:42:16  aml
# Some performance problems addressed by reducing tag use.
# Several performance problems remain when heavy use is made
# of borders and shading in large spreadsheets.
#
# Revision 1.5  1996/09/15 19:24:16  aml
# Rulling and shading.
# Optionally hide cell borders.
# Works well, but is very slow for large spreadsheets.
#
# Revision 1.4  1996/09/14  23:55:53  aml
# Created cell shading.
#
# Revision 1.3  1996/09/04  14:29:52  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.2  1996/09/02 10:51:13  aml
# Cell fonts created, loaded and saved.
# Row height created.
#
# Revision 1.1  1996/09/01  20:26:34  aml
# Initial revision
#