;;;
;;; elmo-filter.el -- Filtered Folder Interface for ELMO.
;;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;;;
(require 'elmo-msgdb)

(defun elmo-filter-msgdb-create (spec numlist new-mark already-mark 
				      seen-mark important-mark seen-list)
  (if (eq (nth 2 spec) 'partial)
      (elmo-msgdb-create (nth 4 spec)
			 numlist 
			 new-mark
			 already-mark
			 seen-mark important-mark seen-list)
    (elmo-msgdb-create-as-numlist (nth 4 spec)
				  numlist
				  new-mark
				  already-mark
				  seen-mark important-mark seen-list)))

(defun elmo-filter-msgdb-create-as-numlist (spec numlist new-mark already-mark
						 seen-mark important-mark 
						 seen-list)
  (elmo-msgdb-create-as-numlist (nth 4 spec)
				numlist
				new-mark
				already-mark
				seen-mark important-mark seen-list))
  
(defun elmo-filter-list-folders (spec &optional hierarchy)
  nil
  )

(defun elmo-filter-append-msg (spec string)
  (elmo-call-func (nth 4 spec) string))

(defun elmo-filter-read-msg (spec number outbuf)
  (elmo-call-func (nth 4 spec) "read-msg" number outbuf))

(defun elmo-filter-delete-msgs (spec msgs)
  (elmo-call-func (nth 4 spec) "delete-msgs" msgs))

(defun elmo-filter-list-folder (spec)
  (let ((by (nth 1 spec))
	(key (nth 2 spec))
	(value (nth 3 spec))
	(folder (nth 4 spec))
	msgs
	)
    (cond 
     ((eq by 'partial)
      (cond 
       ((or (string= key "since")
	    (string= key "before"))
	(elmo-search folder (concat key " " value)))
       ((string= key "last")
	(setq msgs (elmo-list-folder folder))
	(nthcdr (max (- (length msgs) value) 
		     0)
		msgs))
       ((string= key "first")
	(setq msgs (elmo-list-folder folder))
	(let ((rest (nthcdr value msgs)))
	  (mapcar '(lambda (x) 
		     (delete x msgs)) rest))
	msgs)))
     ((eq by 'unmatch)
      )
     ((eq by 'match)
      (elmo-search folder (concat key " " value))))))

(defun elmo-filter-max-of-folder (spec)
  (elmo-call-func (nth 4 spec) "max-of-folder"))

(defun elmo-filter-folder-exists-p (spec)
  t ; ?
  )

(defun elmo-filter-create-folder (spec)
  ;;noop
  )

(defun elmo-filter-search (spec key &optional numlist)
  ;; search from messages in this folder
  (elmo-list-filter 
   numlist 
   (elmo-call-func (nth 4 spec) "search" key (elmo-filter-list-folder spec))))

(defun elmo-filter-use-cache-p (spec number)
  (elmo-call-func (nth 4 spec) "use-cache-p" number)
  )

(defun elmo-filter-local-file-p (spec number)
  (elmo-call-func (nth 4 spec) "local-file-p" number)
  )

(defun elmo-filter-get-msg-filename (spec number)
  ;; This function may be called when elmo-filter-local-file-p()
  ;; returns t.
  (elmo-call-func (nth 4 spec) "get-msg-filename" number)
  )

(provide 'elmo-filter)
  
