#!--PERL--


%week = ('en' => [('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday')],
	 'fr' => [('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi')],
	 'es' => [('Domingo','Lunes','Martes','Miercoles','Jueves','Viernes','Sbado')]
	 );

## Equivalent of languages found in HTTP client 
## (HTTP_ACCEPT_LANGUAGE environment var)
%lang_equiv = ('en' => 'us');

## Used to set LC_ALL env variable
%locale_equiv = ('fr' => 'fr_FR',
		 'us' => 'en_US',
		 'es' => 'es_ES',
		 'de' => 'de_DE',
		 'it' => 'it_IT');

%languages = ('fr' => 'franais',
	      'us' => 'english',
	      'es' => 'espaol',
	      'de' => 'deutch',
	      'it' => 'italiano',
	      'cn-big5' => 'chinese (Hong Kong & Taiwan)',
              'cn-gb' => 'chinese (Mainland)'
	      );

%reception_mode = ('mail' => 'normal',
		   'digest' => 'compilation',
		   'nomail' => 'nomail');

@data_sources = ('file','database','include');

@visibilities = ('conceal','noconceal');

@receptions = ('mail','digest','nomail');

@web_archive_access = ('public','private','owner','listmaster','closed');

@archive_period = ('day','week','month','quarter','year');

@archive_access = ('public','private','owner','closed');

@user_options = ('reception','visibility');

%filenames = ('welcome.tpl' => {'fr' => 'message de bienvenue',
				'es' => 'Mensaje Bienvenida',
				'us' => 'welcome message'},
	      'bye.tpl' => {'fr' => 'message de dsabonnement',
			    'es' => 'Anulacin subscripcin',
			    'us' => 'unsubscription message'},
	      'removed.tpl'=> {'fr' => 'message de suppression',
			       'es' => 'Mensaje de supresin',
			       'us' => 'deletion message'},
	      'message.footer' => {'fr' => 'attachement de fin de message',
				   'es' => 'Pie de mensaje',
				   'us' => 'message footer'},
	      'message.header' => {'fr' => 'attachement de dbut de message',
				   'es' => 'Cabecera de mensaje',
				   'us' => 'message header'},
	      'remind.tpl' => {'fr' => 'message de rappel individualis',
			       'es' => 'Mensaje de recordatorio',
			       'us' => 'remind message'},
	      'invite.tpl' => {'fr' => 'message d\'invitation  s\'abonner',
			       'es' => 'Mensaje de invitacin a subscribirse',
			       'us' => 'subscribing invitation message'},
	      'helpfile.tpl' => {'fr' => 'fichier d\'aide',
				 'es' => 'Fichero de ayuda',
				 'us' => 'helpfile'},
	      'lists.pl' => {'fr' => 'liste des listes',
			     'es' => 'Directorio de listas',
			     'us' => 'list of lists'},
	      'info' => {'fr' => 'description de la liste',
			 'es' => 'Descripcin de la lista',
			 'us' => 'list description'}
	      );

@list_parameters = ('owner','editor','subscribe','unsubscribe','send','review','remind','add',
                    'del','archive','web_archive','visibility','subject','max_size','reply_to',
		    'custom_header','custom_subject','footer_type','host','digest','user_data_source',
		    'include_list','include_file','include_sql_query','include_ldap_query',
                    'priority','default_user_options','account','topics',
                    'comment','creation','update');

## Defined in RFC 1893
%bounce_status = ('1.0' => 'Other address status',
		  '1.1' => 'Bad destination mailbox address',
		  '1.2' => 'Bad destination system address',
		  '1.3' => 'Bad destination mailbox address syntax',
		  '1.4' => 'Destination mailbox address ambiguous',
		  '1.5' => 'Destination mailbox address valid',
		  '1.6' => 'Mailbox has moved',
		  '1.7' => 'Bad sender\'s mailbox address syntax',
		  '1.8' => 'Bad sender\'s system address',
		  '2.0' => 'Other or undefined mailbox status',
		  '2.1' => 'Mailbox disabled, not accepting messages',
		  '2.2' => 'Mailbox full',
		  '2.3' => 'Message length exceeds administrative limit',
		  '2.4' => 'Mailing list expansion problem',
		  '3.0' => 'Other or undefined mail system status',
		  '3.1' => 'Mail system full',
		  '3.2' => 'System not accepting network messages',
		  '3.3' => 'System not capable of selected features',
		  '3.4' => 'Message too big for system',
		  '4.0' => 'Other or undefined network or routing status',
		  '4.1' => 'No answer from host',
		  '4.2' => 'Bad connection',
		  '4.3' => 'Routing server failure',
		  '4.4' => 'Unable to route',
		  '4.5' => 'Network congestion',
		  '4.6' => 'Routing loop detected',
		  '4.7' => 'Delivery time expired',
		  '5.0' => 'Other or undefined protocol status',
		  '5.1' => 'Invalid command',
		  '5.2' => 'Syntax error',
		  '5.3' => 'Too many recipients',
		  '5.4' => 'Invalid command arguments',
		  '5.5' => 'Wrong protocol version',
		  '6.0' => 'Other or undefined media error',
		  '6.1' => 'Media not supported',
		  '6.2' => 'Conversion required and prohibited',
		  '6.3' => 'Conversion required but not supported',
		  '6.4' => 'Conversion with loss performed',
		  '6.5' => 'Conversion failed',
		  '7.0' => 'Other or undefined security status',
		  '7.1' => 'Delivery not authorized, message refused',
		  '7.2' => 'Mailing list expansion prohibited',
		  '7.3' => 'Security conversion required but not possible',
		  '7.4' => 'Security features not supported',
		  '7.5' => 'Cryptographic failure',
		  '7.6' => 'Cryptographic algorithm not supported',
		  '7.7' => 'Message integrity failure');


## Load WWSympa configuration file
sub load_config {
    my $file = pop;

    ## Valid params
    my %default_conf = (log_facility => 'LOCAL2',
			sympa_conf_file => '/etc/sympa.conf',
			wws_path => '--INSTALLDIR--',
			arc_path => '/home/httpd/html/arc',
			bounce_path => '/var/bounce',
			cookie_expire => 30,
			review_page_size => 20,
			mhonarc => '/usr/bin/mhonarc',
			mhonarc_ressources => 'mhonarc-ressources',
			archive_default_index => 'thrd',
			archived_pidfile => 'archived.pid',		  
			bounced_pidfile => 'bounced.pid',
			title => 'Your Mailing Lists Service',
			site_url => 'http://www.your.site/',
			site_anchor => 'Your Site',
			use_fast_cgi => 1
			);

    my $conf = \%default_conf;

    unless (open (FILE, $file)) {
	printf STDERR "load_config: unable to open $file\n";
	return undef;
    }
    
    while (<FILE>) {
	next if /^\s*\#/;

	if (/^\s*(\S+)\s+(.+)\s*$/i) {
	    my ($k, $v) = ($1, $2);
	    if (defined ($conf->{$k})) {
		$conf->{$k} = $v;
	    }else {
		&wwslog ('info', 'unknown parameter %s', $k);
	    }
	}
	next;
    }
    
    close FILE;
    return $conf;
}

## Load HTTPD MIME Types
sub load_mime_types {
    my $types = {};

    @localisation = ('/etc/mime.types', '/usr/local/apache/conf/mime.types',
		     '/etc/httpd/conf/mime.types','mime.types');

    foreach my $loc (@localisation) {
	next unless (-r $loc);

	unless(open (CONF, $loc)) {
	    printf STDERR "load_mime_types: unable to open $loc\n";
	    return undef;
	}
    }
    
    while (<CONF>) {
	next if /^\s*\#/;
	
	if (/^(\S+)\s+(.+)\s*$/i) {
	    my ($k, $v) = ($1, $2);
	    
	    my @extensions = split / /, $v;
	    
	    foreach my $ext (@extensions) {
		$types->{$ext} = $k;
	    }
	    next;
	}
    }
    
    close FILE;
    return $types;
}

## Return a message to the client
sub message {
    my ($msg) = pop;

    $param->{'error_msg'} ||= $msg;

}

## Check user password in sympa database
sub check_pwd {
    my ($email, $pwd) = @_;
    my $user = &List::get_user_db($email);
    my $real_pwd = $user->{'password'};

    unless ($real_pwd) {
	&wwslog('info', 'password not found or user %s unknown', $email);
	&message('pwd_not_found');
	return undef;
    }

    unless ($pwd eq $real_pwd) {
        &wwslog('info', 'check_pwd: incorrect password');
	&message('incorrect_password');
        return undef;
    } 

    return 1;
}

## Returns cookie information
sub get_cookie {
#    &wwslog('debug', 'get_cookie');
    my %cookie;

    ## Scan parameters
    foreach (split /;/, $ENV{'HTTP_COOKIE'}) {
	if ( /^\s*user\=(.*):(\S+)\s*$/ ) {
	    my ($email, $mac) = ($1, $2);
#	    &wwslog('debug', '%s - %s - %s', $1, $2);

	    ## Check the MAC
	    
	    my $user;
	    unless ($user = &List::get_user_db($email)) {
		&message('auth_unknown_user');
		&wwslog('info', 'get_cookie: Cannot find user %s in database', $email);
		return undef;
	    }

	    unless (&get_mac($email, $user->{'password'}, 'user') eq $mac) {
		&message('auth failed');
		&wwslog('info', 'get_cookie: auth failed for user %s', $email);
		return undef;
	    }

	    ## For the parser to display an empty field instead of [xxx]
	    $user->{'gecos'} ||= '';
	    $user->{'cookie_delay'} ||= 0;
	    $user->{'init_passwd'} = 1 if ($user->{'password'} =~ /^INIT/);

	    return $user;
	}
    }
    
    return undef;
}

## Set User and Priv cookies
sub set_cookie {
    my ($email, $mode) = @_ ;

    unless ($email) {
	&wwslog('info', 'set_cookie: no email parameter');
	&message('set_cookie_error');
	return undef;
    }

    ## Get passwd
    my $user = &List::get_user_db($email);
    my $passwd = $user->{'password'};
    my $date;

    if ($mode eq 'reset') {
	$date = 'Tue,1-Jan-1970 10:10:10 GMT';
    }else {
	$date = &get_exp_date($email);
    }

    ## Send cookie to the client
    printf "Set-Cookie: user=%s:%s; expires=%s; path=/\n", $email, &get_mac($email, $passwd, 'user'), $date;
    
    return 1;
}

## Return expiration date for a given user
sub get_exp_date {
    my ($email) = @_;
    my $delay;

    ## Get the expire delay
    my $user = &List::get_user_db($email);
    $delay = $user->{'cookie_delay'} || $wwsconf->{'cookie_expire'};
    
    ## Keep locale and set it to 
    my $locale = $ENV{'LC_ALL'};
    &POSIX::setlocale(&POSIX::LC_ALL, 'C');

    my $date = &POSIX::strftime("%A, %d-%b-%Y %H:%M:%S GMT", gmtime(time + (60 * $delay) ));

    ## Restore locale
    &POSIX::setlocale(&POSIX::LC_ALL, $locale);

    return $date;
}
    
## returns Message Authentication Check code
sub get_mac {
        my ($email, $passwd, $type) = @_;
	my $md5 = new MD5;

	$md5->reset;
	$md5->add($email.$passwd.$type);
	return substr( unpack("H*", $md5->digest) , -6 );
}

sub new_passwd {

    srand(time||$$);
    my $total = `wc -l $wwsconf->{'wws_path'}/dico`;

    my $index = int(rand($total));
    
    open DICO, "$wwsconf->{'wws_path'}/dico";
    while (<DICO>) {
	last if $index-- == 0;
    }
    my $passwd = $_;
    chomp $passwd;
    close DICO;

    return 'INIT'.$passwd;
}

## Write to log
sub wwslog {
    my $facility = shift;
    my $msg = shift;

    my $remote = $ENV{'REMOTE_HOST'} || $ENV{'REMOTE_ADDR'};

    $msg = "[list $param->{'list'}] " . $msg
	if $param->{'list'};

    $msg = "[user $param->{'user'}{'email'}] " . $msg
	if $param->{'user'}{'email'};

    $msg = "[client $remote] ".$msg
	if $remote;
    
    return &do_log($facility, $msg, @_);
}

## Basic check of an email address
sub valid_email {
    my $email = shift;

    $email =~ /^(\S+|\".*\")(@\S+)?$/;

}

sub init_passwd {
    my ($email, $data) = @_;
    
    my ($passwd, $user);
    
    if (&List::is_user_db($email)) {
	$user = &List::get_user_db($email);
	
	$passwd = $user->{'password'};
	
	unless ($passwd) {
	    $passwd = &new_passwd();
	    
	    unless ( &List::update_user_db($email,
					   {'password' => $passwd,
					    'lang' => $user->{'lang'} || $data->{'lang'}} )) {
		&message('update_failed');
		&wwslog('info','init_passwd: update failed');
		return undef;
	    }
	}
    }else {
	$passwd = &new_passwd();
	unless ( &List::add_user_db({'email' => $email,
				     'password' => $passwd,
				     'lang' => $data->{'lang'},
				     'gecos' => $data->{'gecos'}})) {
	    &message('add_failed');
	    &wwslog('info','init_passwd: add failed');
	    return undef;
	}
    }
    
    return 1;
}

## Escape weird characters
sub escape_chars {
    my $s = shift;

    $s =~ s/\%/\%25/g;
    $s =~ s/\"/\%22/g;
    $s =~ s/\s/\%20/g;
    $s =~ s/\//\%2f/g;
    
    return $s;
}

## Unescape weird characters
sub unescape_chars {
    my $s = shift;

    $s =~ s/\%25/\%/g;
    $s =~ s/\%22/\"/g;
    $s =~ s/\%20/ /g;
    $s =~ s/\%2f/\//g;
    
    return $s;
}

1;






