## This module does just the initial setup for the international
## messages.

package Language;

require Exporter;
use Carp;
@ISA = qw(Exporter);
@EXPORT = qw(Msg);

use strict;
use Locale::Msgcat;
use Log;
use Version;

my $Message = new Locale::Msgcat;
my $isopen;

## Robot language
my $sympa_lang;

sub SetLang {
    my $lang = shift;
#    &do_log('debug2', 'SetLang(%s)', $lang);

    
    ## Now check if the file exists
    unless (-r "$Conf::Conf{'msgcat'}/$lang.cat") {
	do_log('info','Locale file %s not found', "$Conf::Conf{'msgcat'}/$lang.cat");
	return undef;
    }
    
    $Message->catclose() if ($isopen);

    unless ($isopen = $Message->catopen("$Conf::Conf{'msgcat'}/$lang.cat", 1)) {
	do_log('info','Locale file %s.cat not used, using builtin messages', $lang);
	return undef;
    }
    
    do_log('info', 'Using locale file %s.cat version %s', $lang, Msg(1, 102, $Version));
    
    return $isopen;
}

sub Msg {
    
    if ($isopen) {
	$Message->catgets(@_);
    }else {
	$_[2];
    }
}

1;
