/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __PGP_H__
#define __PGP_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include "gtkmanip.h"
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <signal.h>

#include "smtpio.h"
#include "parse.h"

typedef struct execute_handle
{
   int pipefd1[2], pipefd2[2];
   pid_t pid;
   FILE *fpin, *fpout;
} *Execution;

gint set_tmp_path (void);

void pgp_bzero_stdio(void);

gint pgp_gen_stdio(void);

gint pgp_gen_filename(void);

gint pgp_detect(gchar *text);

gchar *pgp_encrypt(gchar *text, gchar *recipients, gchar *passphrase, gint use_gnupg, gint pgp_sign);

gchar *pgp_decrypt(gchar *text, gchar *passphrase, gint use_gnupg);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
