/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mesgreader.h"
#include "gti.h"

/* external variables */
extern gchar *mesg_body_font;


GtkWidget* create_frmMesgReader (gchar *mesg, gchar *title)
{
  GtkWidget *frmMesgReader;
  GtkWidget *hbox;
  GtkWidget *txtMesg;
  GtkWidget *vscrollbar;
  GdkFont *fixed_font = NULL;

  frmMesgReader = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmMesgReader, "frmMesgReader");
  gtk_object_set_data (GTK_OBJECT (frmMesgReader), "frmMesgReader", frmMesgReader);
  gtk_widget_set_usize (frmMesgReader, 512, 550);
  gtk_signal_connect_object (GTK_OBJECT (frmMesgReader), "destroy",
                             GTK_SIGNAL_FUNC (on_frmMesgReader_destroy),
                             GTK_OBJECT (frmMesgReader));
  if (title != NULL)
     gtk_window_set_title (GTK_WINDOW (frmMesgReader), title);
  else
     gtk_window_set_title (GTK_WINDOW (frmMesgReader), _("Spruce Message Reader"));
  gtk_window_set_policy (GTK_WINDOW (frmMesgReader), TRUE, TRUE, FALSE);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox, "hbox");
  gtk_object_set_data (GTK_OBJECT (frmMesgReader), "hbox", hbox);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (frmMesgReader), hbox);

  /* load a fixed font */
  if (mesg_body_font != (gchar*)NULL)
     fixed_font = gdk_font_load(mesg_body_font);
  
  txtMesg = gtk_text_new (NULL, NULL);
  gtk_text_set_word_wrap (GTK_TEXT(txtMesg), TRUE);
  gtk_widget_set_name (txtMesg, "txtMesg");
  gtk_object_set_data (GTK_OBJECT (frmMesgReader), "txtMesg", txtMesg);
  gtk_widget_show (txtMesg);
  gtk_box_pack_start (GTK_BOX (hbox), txtMesg, TRUE, TRUE, 0);
  gtk_widget_realize (txtMesg);
  gti (GTK_TEXT (txtMesg), fixed_font, NULL, NULL, mesg, -1);

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT(txtMesg)->vadj);
  gtk_widget_set_name (vscrollbar, "vscrollbar");
  gtk_object_set_data (GTK_OBJECT (frmMesgReader), "vscrollbar", vscrollbar);
  gtk_widget_show (vscrollbar);
  gtk_box_pack_start (GTK_BOX (hbox), vscrollbar, FALSE, FALSE, 0);

  return frmMesgReader;
}

void on_frmMesgReader_destroy (GtkWidget *widget, gpointer user_data)
{
   gtk_widget_destroy(widget);
}


