#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the file called
#  COPYING, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#  The routines which handler sash functions in the browser window
#
# Arguments:
# root      -  The parent window of the sash
# {Y}       -  The Y cooordinate of the sash
proc SashStart { root } {
    $root configure -relief raised -bd 2
    raise $root
}
proc SashMove { root Y } {    
    set height [ winfo height $root ].0
    set mheight [expr [winfo reqheight $root.middle].0 - \
    	([$root.middle cget -bd]*2)]
    set val [ expr ($Y - ([winfo rooty $root]+($mheight/2.0))) /$height ]
    set mval [ expr $mheight / $height ]
    
    if { $val >= 0 && $val <= [expr 1.0 - $mval] } {
	place $root.middle -rely $val
    }
}
proc SashStop { root } {
    $root.middle configure -relief flat -bd 0
    update idletasks
    set height [ winfo height $root ].0
    set mheight [ winfo height $root.middle].0
    set val [expr [winfo y $root.middle].0/$height]
    set bval [expr ([winfo y $root.middle].0+$mheight)/$height]
    
    place $root.top -relheight $val
    place $root.bottom -relheight [ expr 1.0 - $bval ]
    update idletasks
}

proc TopSash { root } {
    global b
    upvar $root.mailboxview win
    if $win(mboxvis) {
	pack forget $root.mailboxview
	set win(mboxvis) 0
	$root.sash.dimple configure -image down
	set b($root.sash) mbv_sash_open
    } else {
	pack $root.mailboxview -before $root.sash -side top -fill both
	set win(mboxvis) 1
	$root.sash.dimple configure -image up
	set b($root.sash) mbv_sash_close
    }
}

# MessDragStart --
#
# Start a drag operation in the message list
#
# Arguments:
# handler - The handler which identifies the folder window
# index   - The index of this selection
proc MessDragStart {handler index} {
    upvar #0 $handler fh
    set fh(start_drag) $index
    $fh(message_list) tag add sel "$index linestart" "$index lineend"
}

# MessDrag --
#
# Carry out a drag operation in the message list
#
# Arguments:
# handler - The handler which identifies the folder window
# index   - The index of this selection
proc MessDrag {handler index} {
    upvar #0 $handler fh
    $fh(message_list) tag add sel "$index linestart" "$index lineend"
    $fh(message_list) see $index
}

# MessDragStop --
#
# Stop a drag operation in the message list
#
# Arguments:
# handler - The handler which identifies the folder window
# index   - The index of this selection
proc MessDragStop {handler index} {
    upvar #0 $handler fh

    set end $index
    set start $fh(start_drag)
    $fh(message_list) tag remove sel 1.0 end
    if {$fh(start_drag) < $index} { 
	$fh(message_list) tag add flagged "$start linestart" "$end lineend"
	for {set i [expr int($fh(start_drag))-1]} {$i <= [expr $end-1]} \
	    {incr i 1} {
		$fh(folder_handler) setFlag $i flagged 1
		FolderListRefreshEntry $handler $i
	    }
    } elseif {[expr int($index)] < [expr int($fh(start_drag))]} {
	$fh(message_list) tag add flagged "$end linestart" "$start lineend"
	for {set i [expr int($end)-1]} {$i <= [expr $fh(start_drag)-1]} \
	    {incr i 1} {
		$fh(folder_handler) setFlag $i flagged 1
		FolderListRefreshEntry $handler $i
	    }
    } else {
	set i [expr int($end)-1]
	if [$fh(folder_handler) getFlag $i flagged] {
	    $fh(folder_handler) setFlag $i flagged 0
	    $fh(message_list) tag remove flagged "$end linestart" "$end lineend"
	} else {
	    $fh(folder_handler) setFlag $i flagged 1
	    $fh(message_list) tag add flagged "$end linestart" "$end lineend"
	}	    
	FolderListRefreshEntry $handler $i
    }
    $fh(message_list) tag raise flagged
}
