/* (c) 1992, 1993, 1994 by Axel Zinser aka Fifi (fifi@hiss.han.de) */
#include <stdio.h>
#include "alloc.h"

#ifdef MDEBUG
struct mdebug {
	struct mdebug *next;
	char		*adr;
	unsigned long	length;
	} *mdp = 0, *mdebug = 0;
#endif

char *
ckalloc(n,s)
unsigned long n,s;
{
	char *cp = (char*)calloc(n,s);

	if (cp) {
#ifdef MDEBUG
		mdp = (struct mdebug *)calloc(1,sizeof(struct mdebug));
		mdp->adr = cp;
		mdp->length = n*s;
		mdp->next = mdebug;
		mdebug = mdp;
#endif
		return(cp);
	}

	fprintf(stderr,"No more memory in ckalloc\n");
	exit(-3);
}

#ifdef MDEBUG
void
ckfree(cp)
char *cp;
{
	mdp = mdebug;
	while(mdp && (mdp->adr != cp)) mdp = mdp->next;
	if (!mdp) {
		fprintf(stderr,"ERROR: try to deallocate memory at %x - ignored\n",cp);
		return;
	}
	if (mdp && !mdp->length) {
		fprintf(stderr,"ERROR: try to deallocate deallocated memory at %x - ignored\n",cp);
		return;
	}
	free(cp);
	mdp->length = 0;
	return;
}
#endif
