/*
              Y I F F   C O N F I G U R A T I O N   W I Z A R D

               Copyright (C) 1997, 1998, 1999, 2000 WolfPack

 */

#ifndef YIFFCONFIG_H
#define YIFFCONFIG_H

#include <db.h>
#include <sys/types.h>
#include <limits.h>

#include <Y2/Y.h>
#include <Y2/Ylib.h>

#include <gtk/gtk.h>

#include "../include/os.h"
#include "gendialog.h"



/*
 *	Default path and name of configuration file:
 */
#define DEF_RCFILE		"/usr/etc/yiffrc"

/*
 *	Default YIFF sound server start command:
 */
#define DEF_YSERVER_START_CMD	"/usr/sbin/yiff"

/*
 *	Default recorder address and port number (connect argument):
 */
#define DEF_YSERVER_ADDRESS	"127.0.0.1:9433"



/*
 *	Program name and version:
 */
#define PROG_NAME	"YIFF Configuration Wizard"
#define PROG_VERSION		"2.06"

#define PROG_VERSION_MAJOR	2
#define PROG_VERSION_MINOR	6

/*
 *	Program usage message:
 */
#define PROG_USAGE_MESG	"\
Usage: yiffconfig [configfile] [options]\n\
\n\
    [configfile] specifies the configuration file to be loaded (the\n\
    (configuration file to be saved will be asked interactivly).\n\
\n\
    [options] can be any of the following:\n\
\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n"


/*
 *	Program copyright string:
 */
#define PROG_COPYRIGHT "\
Copyright (C) 1997, 1998, 1999, 2000 Wolfpack Development Organization."


/*
 *	Total pages (don't change this):
 */
#define YC_TOTAL_PAGES	5


/*
 *	Dialog:
 */
extern gen_dialog_struct dialog;


typedef struct {

	char rcfile[PATH_MAX + NAME_MAX];

} fname_struct;
extern fname_struct fname;

/*
 *	Audio modes list item data structure:
 */
typedef struct {

	gint	sample_rate,
		channels,
		sample_size,

		fragment_size,		/* In bytes. */
		num_fragments,
		allow_fragmenting,

		flip_stereo,
		direction;	/* 1 for record, 0 for play. */

	glong	cycle_us,
		write_ahead_us;

} audio_mode_struct;


/*
 *	Options structure:
 */
typedef struct {

	gint port;
	glong refresh_int_us;
	gchar device[PATH_MAX + NAME_MAX];
	gchar mixer[PATH_MAX + NAME_MAX];
	gchar midi_play_cmd[PATH_MAX + NAME_MAX];


} option_struct;
extern option_struct option;

/*
 *	Yiffconfig window:
 */
typedef struct {

        GtkWidget       *toplevel,
			*page_toplevel[YC_TOTAL_PAGES],
			*back_btn,
			*back_btn_label,
			*next_btn,
			*next_btn_label;

	/* Widgets on page 0. */
	GtkWidget	*svr_addr_text,
			*svr_start_cmd_text,
			*no_start_svr_btn;

	/* Widgets on page 1. */
	GtkWidget	*audio_modes_list,
			*add_mode_btn,
			*remove_mode_btn,
			*sample_rate_combo,
			*sample_size_tb8,
			*sample_size_tb16,
			*fragment_size_combo,
			*channels_tb1,
			*channels_tb2,
			*cycle_scale,
			*cycle_calc_btn,
			*apply_changes_btn,
			*play_object_text,
			*play_btn;

	/* Widgets on page 2. */
	GtkWidget	*port_num_text,
			*device_name_text,
			*mixer_name_text,
			*midi_play_cmd_text,
			*refresh_interval_text;


	/* Widgets on page 3. */
	GtkWidget	*sound_paths_list,
			*sound_path_add_text;

	/* Widgets on page 4. */
	GtkWidget	*rcfile_name_text;


	gint	cur_page;

	audio_mode_struct **audio_mode;
	gint	total_audio_modes,
		cur_sel_audio_mode;	/* Currently selected audio mode. */

	gint	total_sound_paths,
		cur_sel_sound_path;

	gchar *midi_driver_command;

	YConnection *con;

} yc_win_struct;
extern yc_win_struct yc_win;


/*
 *	Add mode dialog.
 */
typedef struct {

	GtkWidget	*toplevel,
			*name_text,
			*add_btn,
			*cancel_btn;

	yc_win_struct	*ref_ycw;

} add_mode_dialog_struct;
extern add_mode_dialog_struct add_mode_dialog;



/* In addmode.c */
extern void AddModeAddBtnCB(GtkWidget *widget, gpointer data);
extern void AddModeCancelBtnCB(GtkWidget *widget, gpointer data);
extern void AddModeTextActivateCB(GtkWidget *widget, gpointer data);
extern void AddModeDestroyCB(
        GtkWidget *widget,
        GdkEvent *event,
        gpointer data
);
extern int AddModeCreate(void);
extern void AddModeDestroy(void);


/* In rcfile.c */
extern int RCLoadFromFile(char *filename);

/* In yccreate.c */
extern GtkWidget *YCCreateLoadXPM(
	GtkWidget *ref_window,
	gchar **xpmdata
);
extern int YCCreate(void);
extern void YCDeleteAllAudioModes(yc_win_struct *ycw);
extern void YCDeleteAllSoundPaths(yc_win_struct *ycw);
extern void YCDestroy(void);


/* In yccb.c */
extern void YCSignalHandler(int s);
extern int YCTimeoutCB(gpointer data);
extern void YCExitCB(
        GtkWidget *widget,
        GdkEvent *event,
        gpointer data
);
extern void YCPageChangeCB(gint new_page_num);
extern void YCBackBtnCB(GtkWidget *widget, gpointer data);
extern void YCNextBtnCB(GtkWidget *widget, gpointer data);

extern void YCDoNotStartServerBtnCB(GtkWidget *widget, gpointer data);

extern void YCAddModeBtnCB(GtkWidget *widget, gpointer data);
extern void YCRemoveModeBtnCB(GtkWidget *widget, gpointer data);
extern void YCModeShiftUpBtnCB(GtkWidget *widget, gpointer data);
extern void YCModeShiftDownBtnCB(GtkWidget *widget, gpointer data);
extern void YCAudioModesListCB(
        GtkWidget *clist,
        gint row,
        gint column,
        GdkEventButton *event,
        gpointer data
);
extern void YCCalculateBtnCB(GtkWidget *widget, gpointer data);
extern void YCCycleScaleCB(GtkAdjustment *adj, GtkWidget *scale);
extern void YCApplyChangesBtnCB(GtkWidget *widget, gpointer data);

extern void YCRemoveSoundPathBtnCB(GtkWidget *widget, gpointer data);
extern void YCAddSoundPathBtnCB(GtkWidget *widget, gpointer data);
extern void YCSoundPathShiftUpBtnCB(GtkWidget *widget, gpointer data);
extern void YCSoundPathShiftDownBtnCB(GtkWidget *widget, gpointer data);
extern void YCSoundPathListCB(
        GtkWidget *clist,
        gint row,
        gint column,
        GdkEventButton *event,
        gpointer data
);




/* In main.c */


#endif	/* YIFFCONFIG_H */
