/*								-*- C++ -*-
 * $Id: DEV_screendc.h,v 1.1 1996-09-25 11:06:04+02 mho Exp $
 *
 * Purpose: device context to draw on the root window
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef ScreenDC_h
#define ScreenDC_h

#ifdef __GNUG__
#pragma interface
#endif

class wxScreenDC : public wxCanvasDC {
DECLARE_DYNAMIC_CLASS(wxScreenDC)
public:
    wxScreenDC(void);
    ~wxScreenDC(void);

    Bool StartDrawingOnTop(void);
    Bool StartDrawingOnTop(wxWindow *window);
    Bool StartDrawingOnTop(wxRectangle *rect);
    Bool EndDrawingOnTop(void);

    // ask, if a part of the DC is exposed
    int IsExposed(float x, float y);
    int IsExposed(float x, float y, float width, float height);
private:
#   ifdef Have_X_Types
    static Bool   m_drawOnTop;
    static Window m_overlayWindow;
    static int    m_overlayWindowX;
    static int    m_overlayWindowY;
#   endif
};

#endif // ScreenDC_h
