/*								-*- C++ -*-
 * $Id: DAT_object.h,v 1.2 1996-11-19 13:29:57+01 mho Exp $
 *
 * Purpose: Top level object and memory debugging for wxWindows
 *
 * Authors: Markus Holzem, Julian Smart and Arthur Seaton
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian, Arthur)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Object_h
#define Object_h

#ifdef __GNUG__
#pragma interface
#endif

//-----------------------------------------------------------------------------
// wxClassInfo: for dynamic object system declarations
//-----------------------------------------------------------------------------

class wxClassInfo;
class wxObject;

typedef wxObject* (*wxObjectConstructorFn)(void);

class wxClassInfo {
public:
    wxClassInfo(char *cName, char *baseName1, char *baseName2,
		int sz, wxObjectConstructorFn fn);

           wxObject*    CreateObject(void);
    static wxClassInfo* FindClass(char *c);
    inline char*        GetClassName(void) { return className; }
    inline char*        GetBaseClassName1(void) { return baseClassName1; }
    inline char*        GetBaseClassName2(void) { return baseClassName2; }
    inline int          GetSize(void) { return objectSize; }
    static void         InitializeClasses(void);
           Bool         IsKindOf(wxClassInfo *info);
private:
    friend wxObject *wxCreateDynamicObject(char *name);
    friend class wxDebugContext;

    char *className;
    char *baseClassName1;
    char *baseClassName2;
    int objectSize;
    wxObjectConstructorFn objectConstructor;

    // Pointers to base wxClassInfos: set in InitializeClasses
    // called from wx_main.cpp
    wxClassInfo *baseInfo1;
    wxClassInfo *baseInfo2;

    static wxClassInfo *first;
    wxClassInfo *next;
};

wxObject *wxCreateDynamicObject(char *name);

//-----------------------------------------------------------------------------
// wxObject: top level object
//-----------------------------------------------------------------------------

/* MATTHEW */
#if WXGARBAGE_COLLECTION_ON
#include "gc_cpp.h"
#define WXGC_IGNORE(ptr) GC_general_register_disappearing_link((void **)&(ptr), NULL)
#define WXGC_ATOMIC (AtomicGC)
#define WXGC_NOT (NoGC)
class wxObject : public gc_cleanup {
#else
#define WXGC_IGNORE(ptr)
#define WXGC_ATOMIC
#define WXGC_NOT
class wxObject {
#endif

public:
    wxObject(void);
    virtual ~wxObject(void);

    WXTYPE __type;

    static  wxClassInfo  classwxObject;
    virtual wxClassInfo* GetClassInfo(void) { return &classwxObject; }
            Bool         IsKindOf(wxClassInfo *info);
    virtual istream&     LoadObject(istream&);
    virtual ostream&     SaveObject(ostream&);
#if WXDEBUG
    virtual void Dump(ostream& str);
#endif
#if WXDEBUG && USE_MEMORY_TRACING
    void *operator new(size_t size);
    void *operator new[](size_t size);
    void* operator new(size_t size, char *fileName, int lineNum);
    void* operator new[](size_t size, char *fileName, int lineNum);
    void  operator delete(void * buf);
    void  operator delete[](void * buf);
#endif
};

#if WXDEBUG && USE_MEMORY_TRACING && USE_GLOBAL_MEMORY_OPERATORS
void *operator new(size_t size);
void *operator new[](size_t size);
void *operator new(size_t size, char *fileName, int lineNum);
void *operator new[](size_t size, char *fileName, int lineNum);
void  operator delete(void *buf);
void  operator delete[](void *buf);
#endif

//-----------------------------------------------------------------------------
// debugging context
//-----------------------------------------------------------------------------

#if WXDEBUG && USE_MEMORY_TRACING

class wxMemStruct;
typedef void (wxMemStruct::*PmSFV)(void);

#ifdef Uses_wxDebugStreamBuf

class wxDebugStreamBuf : public streambuf {
public:
    wxDebugStreamBuf(void);

    int overflow(int i);
    inline int underflow(void) { return EOF; }
    int sync(void);
};

#endif

class wxDebugContext {

private:
    // Store these here to allow access to the list without
    // needing to have a wxMemStruct object.
    static wxMemStruct * _head;
    static wxMemStruct * _tail;

    // Set to FALSE if we're not checking all previous nodes when
    // we do a new. Set to TRUE when we are.
    static Bool _checkPrevious;
protected:
    // Used to set alignment for markers.
    static size_t CalcAlignment ();

    // Returns the amount of padding needed after something of the given
    // size. This is so that when we cast pointers backwards and forwards
    // the pointer value will be valid for a wxMarkerType.
    static size_t GetPadding (const size_t size);

    // Traverse the list.
    static void TraverseList (PmSFV, wxMemStruct *from = NULL);

    static streambuf *streamBuf;
    static ostream *debugStream;

    static int debugLevel;
    static Bool debugOn;

public:
    // Set a checkpoint to dump only the memory from
    // a given point
    static wxMemStruct *checkPoint;
    static wxMemStruct *appCheckPoint;

    wxDebugContext(void);
    ~wxDebugContext(void);

    static Bool HasStream(void) { return (debugStream != NULL); };
    static ostream& GetStream(void) { return *debugStream; }
    static streambuf *GetStreamBuf(void) { return streamBuf; }
    static void SetStream(ostream *stream, streambuf *buf = NULL);
    static Bool SetFile(char *file);
    static Bool SetStandardError(void);
    
    static int GetLevel(void) { return debugLevel; }
    static void SetLevel(int level) { debugLevel = level; }

    static Bool GetDebugMode(void) { return debugOn; }
    static void SetDebugMode(Bool flag) { debugOn = flag; }

    static void SetAppCheckpoint(Bool start = TRUE);
    static void SetCheckpoint(Bool all = FALSE);
    
    // Calculated from the request size and any padding needed
    // before the final marker.
    static size_t PaddedSize (const size_t reqSize);

    // Calc the total amount of space we need from the system
    // to satisfy a caller request. This includes all padding.
    static size_t TotSize (const size_t reqSize);

    // Return valid pointers to offsets within the allocated memory.
    static char * StructPos (const char * buf);
    static char * MidMarkerPos (const char * buf);
    static char * CallerMemPos (const char * buf);
    static char * EndMarkerPos (const char * buf, const size_t size);

    // Given a pointer to the start of the caller requested area
    // return a pointer to the start of the entire alloc\'d buffer.
    static char * StartPos (const char * caller);

    // Access to the list.
    static wxMemStruct * GetHead () { return _head; }
    static wxMemStruct * GetTail () { return _tail; }

    // Set the list sentinals.
    static wxMemStruct * SetHead (wxMemStruct * st) { return (_head = st); }
    static wxMemStruct * SetTail (wxMemStruct * st) { return (_tail = st); }

    // If this is set then every new operation checks the validity
    // of the all previous nodes in the list.
    static Bool GetCheckPrevious () { return _checkPrevious; }
    static void SetCheckPrevious (Bool value) { _checkPrevious = value; }

    // Checks all nodes
    static int Check(void);

    // Print out the list of wxMemStruct nodes.
    static Bool PrintList(void);
    
    // Dump objects
    static Bool Dump(void);
    
    // Print statistics
    static Bool PrintStatistics(Bool detailed = TRUE);
    
    // Print out the classes in the application.
    static Bool PrintClasses(void);
};

#endif

//-----------------------------------------------------------------------------
// macros to store meta-information about classes
//-----------------------------------------------------------------------------

#define DECLARE_DYNAMIC_CLASS(name) \
    public:\
    static wxClassInfo class##name;\
    wxClassInfo *GetClassInfo() { return (&name::class##name); }
#define DECLARE_ABSTRACT_CLASS(name) \
    DECLARE_DYNAMIC_CLASS(name)
#define DECLARE_CLASS(name) \
    DECLARE_DYNAMIC_CLASS(name)

#define IMPLEMENT_DYNAMIC_CLASS(name, basename) \
    wxObject *wxConstructorFor##name(void) { return (wxNEW name()); } \
    wxClassInfo name::class##name(#name, #basename, NULL, \
                                  sizeof(name), wxConstructorFor##name);
#define IMPLEMENT_DYNAMIC_CLASS2(name, basename1, basename2) \
    wxObject *wxConstructorFor##name(void) { return (wxNEW name()); } \
    wxClassInfo name::class##name(#name, #basename1, #basename2, \
                                  sizeof(name), wxConstructorFor##name);
#define IMPLEMENT_ABSTRACT_CLASS(name, basename) \
    wxClassInfo name::class##name(#name, #basename, NULL, sizeof(name), NULL);
#define IMPLEMENT_ABSTRACT_CLASS2(name, basename1, basename2) \
    wxClassInfo name::class##name(#name, #basename1, #basename2, sizeof(name), NULL);
#define IMPLEMENT_CLASS \
    IMPLEMENT_ABSTRACT_CLASS
#define IMPLEMENT_CLASS2 \
    IMPLEMENT_ABSTRACT_CLASS2

#define CLASSINFO(name) \
    (&name::class##name)

#if WXDEBUG && USE_MEMORY_TRACING

// Output a debug mess., in a system dependent fashion.
void wxTrace(const char *fmt ...);
void wxTraceLevel(int level, const char *fmt ...);

#define TRACE wxTrace
#define TRACELEVEL wxTraceLevel
#define DEBUG_NEW new(__FILE__,__LINE__)
#define WXTRACE wxTrace
#define WXTRACELEVEL wxTraceLevel
#define WXDEBUG_NEW new(__FILE__,__LINE__)

#if USE_INTERNAL_MEMORY_TRACING
#define wxNEW new(__FILE__,__LINE__)
#else
#define wxNEW new
#endif

#else // else part for the #if WXDEBUG

inline void wxTrace(const char *WXUNUSED(fmt)) {}
inline void wxTraceLevel(int WXUNUSED(level), const char *WXUNUSED(fmt)) {}

#define TRACE TRUE ? (void)0 : wxTrace
#define TRACELEVEL TRUE ? (void)0 : wxTraceLevel
#define DEBUG_NEW new
#define WXTRACE TRUE ? (void)0 : wxTrace
#define WXTRACELEVEL TRUE ? (void)0 : wxTraceLevel
#define WXDEBUG_NEW new
#define wxNEW new

#endif // WXDEBUG && USE_MEMORY_TRACING

#if WXDEBUG
#define wxASSERT(expression, reason)\
    do { if(!(expression)) __wxASSERT(__FILE__, __LINE__, reason); } while(0)
    void __wxASSERT(char *file, unsigned lineno,
		    char *reason="assert failed");
#else
#define wxASSERT(ignore1, ignore2) \
    ((void) 0)
#endif // WXDEBUG

#endif // Object_h
