'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: catch.n,v 1.2 1998/09/14 18:39:51 stanton Exp $
'\" 
.so man.macros
.TH catch n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
catch \- Evaluate script and trap exceptional returns
.SH SYNOPSIS
\fBcatch\fI script \fR?\fIvarName\fR?
.BE

.SH DESCRIPTION
.PP
The \fBcatch\fR command may be used to prevent errors from aborting
command interpretation.  \fBCatch\fR calls the Tcl interpreter recursively
to execute \fIscript\fR, and always returns a TCL_OK code, regardless of
any errors that might occur while executing \fIscript\fR.  The return
value from \fBcatch\fR is a decimal string giving the
code returned by the Tcl interpreter after executing \fIscript\fR.
This will be \fB0\fR (TCL_OK) if there were no errors in \fIscript\fR;
otherwise
it will have a non-zero value corresponding to one of the exceptional
return codes (see tcl.h for the definitions of code values).  If the
\fIvarName\fR argument is given, then it gives the name of a variable;
\fBcatch\fR will set the variable to the string returned
from \fIscript\fR (either a result or an error message).
.PP
Note that \fBcatch\fR catches all exceptions, including those
generated by \fBbreak\fR and \fBcontinue\fR as well as errors.

.SH KEYWORDS
catch, error
