/*
 * Copyright (c) 1997 Stanford University
 *
 * The use of this software for revenue-generating purposes may require a
 * license from the owners of the underlying intellectual property.
 * Specifically, the SRP protocol may not be used for revenue-generating
 * purposes without license.
 *
 * Within that constraint, permission to use, copy, modify, and distribute
 * this software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notices and this permission
 * notice appear in all copies of the software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef T_DEFINES_H
#define T_DEFINES_H

#ifndef P
#if __STDC__
#define P(x) x
#else
#define P(x) ()
#endif
#endif

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#else /* not STDC_HEADERS */
#ifndef HAVE_STRCHR
#define strchr index
#define strrchr rindex
#endif
char *strchr(), *strrchr(), *strtok();
#ifndef HAVE_MEMCPY
#define memcpy(d, s, n) bcopy((s), (d), (n))
#endif
#endif /* not STDC_HEADERS */

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else  /* not TIME_WITH_SYS_TIME */
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif /* not TIME_WITH_SYS_TIME */

#if HAVE_TERMIOS_H
#include <termios.h>
#define STTY(fd, termio) tcsetattr(fd, TCSANOW, termio)
#define GTTY(fd, termio) tcgetattr(fd, termio)
#define TERMIO struct termios
#define USE_TERMIOS
#elif HAVE_TERMIO_H
#include <sys/ioctl.h>
#include <termio.h>
#define STTY(fd, termio) ioctl(fd, TCSETA, termio)
#define GTTY(fd, termio) ioctl(fd, TCGETA, termio)
#define TEMRIO struct termio
#define USE_TERMIO
#elif HAVE_SGTTY_H
#include <sgtty.h>
#define STTY(fd, termio) stty(fd, termio)
#define GTTY(fd, termio) gtty(fd, termio)
#define TERMIO struct sgttyb
#define USE_SGTTY
#endif

/* Should be defined by configure; GNU_MP is default */
/* #define GNU_MP 1 */
/* #define CRYPTOLIB 1 */

#ifdef CRYPTOLIB
# include "libcrypt.h"
typedef BigInt BigInteger;
#elif GNU_MP
# include "gmp.h"
typedef MP_INT * BigInteger;
#else
no math library specified!
#endif

extern BigInteger BigIntegerFromInt P((unsigned int number));
extern BigInteger BigIntegerFromBytes P((unsigned char * bytes, int length));
extern int BigIntegerToBytes P((BigInteger src, unsigned char * dest));
extern void BigIntegerToHex P((BigInteger src, char * dest));
extern int BigIntegerBitLen P((BigInteger b));
extern int BigIntegerCmp P((BigInteger c1, BigInteger c2));
extern int BigIntegerCmpInt P((BigInteger c1, unsigned int c2));
extern void BigIntegerLShift P((BigInteger result, BigInteger x,
				unsigned int bits));
extern void BigIntegerAdd P((BigInteger result, BigInteger a1, BigInteger a2));
extern void BigIntegerAddInt P((BigInteger result,
				BigInteger a1, unsigned int a2));
extern void BigIntegerSub P((BigInteger result, BigInteger s1, BigInteger s2));
extern void BigIntegerSubInt P((BigInteger result,
				BigInteger s1, unsigned int s2));
/* For BigIntegerMul{,Int}: result != m1, m2 */
extern void BigIntegerMul P((BigInteger result, BigInteger m1, BigInteger m2));
extern void BigIntegerMulInt P((BigInteger result,
				BigInteger m1, unsigned int m2));
extern void BigIntegerDivInt P((BigInteger result,
				BigInteger d, unsigned int m));
extern void BigIntegerMod P((BigInteger result, BigInteger d, BigInteger m));
extern unsigned int BigIntegerModInt P((BigInteger d, unsigned int m));
extern void BigIntegerModMul P((BigInteger result,
				BigInteger m1, BigInteger m2, BigInteger m));
extern void BigIntegerModExp P((BigInteger result, BigInteger base,
				BigInteger expt, BigInteger modulus));
extern void BigIntegerModExpInt P((BigInteger result, BigInteger base,
				   unsigned int expt, BigInteger modulus));
extern int BigIntegerCheckPrime P((BigInteger n));
extern void BigIntegerFree P((BigInteger b));

#endif
