/* File "sym_compiler.h":
 * Compiles malaga symbol files. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

extern void init_sym_compiler (void);
/* Initialise this module. */

extern void terminate_sym_compiler (void);
/* Terminate this module. */

extern void enter_symbol (string_t name, value_t atoms);
/* Enter <name> as a symbol name with atomic symbol list <atoms>
 * in the symbol tree. */

extern void parse_symbols (void);
/* Parse a symbol file. */

extern void write_symbols (string_t file_name);
/* Write symbol table to file <file_name>. */

extern void compile_symbol_file (string_t source_file, 
				 string_t object_file,
				 string_t old_symbol_file);
/* Read symbol file <source_file_name> and create translated file
 * with name <object_file_name>. 
 * If <old_symbol_file> != NULL, include symbols of this file. */
