/* $Id: misctest.c,v 1.9 1998/12/21 23:06:56 marcus Exp $
******************************************************************************

   Test program for the "misc" extension.

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>

#include <ggi/ggi.h>
#include <ggi/ggi_ext.h>

/* Real applications should use #include <ggi/misc.h> instead! */
#include "misc.h"

int main(void)
{
	ggi_visual_t vis;
	ggi_color col;
	ggi_mode mode;
	int temp, inc, width, height;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize misc extension */
	if (ggiMiscInit() != 0) {
		ggiPanic("Unable to initialize LibGGI misc extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the misc extension to the visual */
	if (ggiMiscAttach(vis) < 0) {
		ggiPanic("Unable to attach misc extension to visual\n");
	}

	/* Set foreground color to white */
	col.r = 0xffff;
	col.g = 0xffff;
	col.b = 0xffff;
	ggiSetGCForeground(vis, ggiMapColor(vis, &col));

	/* Check what mode we actually got */
	ggiGetMode(vis, &mode);
	width = mode.visible.x;
	height = mode.visible.y;
	
	/* Draw a bunch of lines... */
	inc = height/66;
	for (temp = 0; temp <= (height-inc); temp += inc) {
		ggiDrawLine(vis, 0, temp, width-1, height-temp);
	}

	/* ...and flush the screen */
	ggiFlush(vis);

	/* Now test the splitline feature */
	for (temp = 0; temp < height; temp++) { 
		ggiSetSplitline(vis, temp);
		ggiFlush(vis);
	}
	
	/* Detach extension from visual */
	ggiMiscDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize misc extension */
	ggiMiscExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
