/********************************************************************************
*                                                                               *
*                      J P E G   I m a g e   O b j e c t                        *
*                                                                               *
*********************************************************************************
* Author: David Tyree   Email: celer@ipro.lug.usf.edu                           *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXJPEGImage.cpp,v 1.4 1999/11/18 07:39:38 jeroen Exp $                   *
********************************************************************************/
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXJPEGImage.h"



/*
  Notes:
*/


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXJPEGImage,FXImage,NULL,0)


// Initialize
FXJPEGImage::FXJPEGImage(FXApp* a,const void *pix,FXuint opts,FXint w,FXint h):
  FXImage(a,NULL,opts,w,h){
  quality=75;
  if(pix){     
    FXMemoryStream ms;
    ms.open((FXuchar*)pix,FXStreamLoad);
    loadPixels(ms);
    ms.close();   
    }
  }    


// Save the pixels only
void FXJPEGImage::savePixels(FXStream& store) const {
  FXColor transp=FXRGB(192,192,192);
  fxsaveJPEG(store,data,transp,width,height,quality);    
  }



// Load pixels only
void FXJPEGImage::loadPixels(FXStream& store){
  FXColor transp;
  if(options&IMAGE_OWNED){FXFREE(&data);}
  fxloadJPEG(store,data,transp,width,height,quality);   
  options&=~IMAGE_ALPHA;
  options|=IMAGE_OWNED;
  }    


// Clean up
FXJPEGImage::~FXJPEGImage(){
  }
