/********************************************************************************
*                                                                               *
*              T h e   P a t h F i n d e r   F i l e   B r o w s e r            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: PathFinder.h,v 1.1 1999/09/14 13:43:46 jeroen Exp $                     *
********************************************************************************/
#ifndef PATHFINDER_H
#define PATHFINDER_H


// PathFinder Main Window
class PathFinderMain : public FXMainWindow {
  FXDECLARE(PathFinderMain)
protected:
  FXMenuBar*         menubar;
  FXHorizontalFrame* toolbar;
  FXSplitter*        splitter;
  FXDirBox*          dirbox;
  FXVerticalFrame*   group1;
  FXVerticalFrame*   subgroup1;
  FXVerticalFrame*   group2;
  FXVerticalFrame*   subgroup2;
  FXDirList*         dirlist;
  FXFileList*        filelist;
  FXTextField*       pattern;
  FXString           directory;
protected:
  PathFinderMain(){}
public:
  enum{
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_DIRECTORYLIST,
    ID_FILELIST,
    ID_DIRBOX,
    ID_SEARCHPATH,
    ID_UPDIRECTORY,
    ID_QUIT,
    ID_MAINWINDOW,
    ID_LAST
    };
public:
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onQuit(FXObject*,FXSelector,void*);
  long onCmdDirTree(FXObject*,FXSelector,void*);
  long onCmdDirectory(FXObject*,FXSelector,void*);
  long onCmdFileClicked(FXObject*,FXSelector,void*);
  long onCmdFileDblClicked(FXObject*,FXSelector,void*);
  long onCmdSetSearchPath(FXObject*,FXSelector,void*);
  long onCmdUpDirectory(FXObject*,FXSelector,void*);
public:
  PathFinderMain(FXApp* a);
  void setDirectory(const FXString& dir);
  virtual void create();
  };


#endif
