/********************************************************************************
*                                                                               *
*                 T o p - L e v e l   W i n d o w   W i d g e t                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXTopWindow.h,v 1.6 1999/11/09 23:58:38 jeroen Exp $                     *
********************************************************************************/
#ifndef FXTOPWINDOW_H
#define FXTOPWINDOW_H


// Decorations
enum FXDecorations {
  DECOR_TITLE    = 0x00020000,        // Window title
  DECOR_MINIMIZE = 0x00040000,        // Minimize button
  DECOR_MAXIMIZE = 0x00080000,        // Maximize button
  DECOR_CLOSE    = 0x00100000,        // Close button
  DECOR_BORDER   = 0x00200000,        // Border
  DECOR_RESIZE   = 0x00400000,        // Resize handles
  DECOR_MENU     = 0x00800000,        // Window menu
  DECOR_ALL      = (DECOR_TITLE|DECOR_MINIMIZE|DECOR_MAXIMIZE|DECOR_CLOSE|DECOR_BORDER|DECOR_RESIZE|DECOR_MENU)
  };
  

// Top level window 
class FXAPI FXTopWindow : public FXShell {
  FXDECLARE_ABSTRACT(FXTopWindow)
protected:
  FXString  title;
  FXIcon   *icon;
  FXIcon   *miniIcon;
  FXint     hspacing;
  FXint     vspacing;
public:
  long onClose(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
protected:
  FXTopWindow(){}
  void settitle();
  void seticons();
  void setdecorations();
  virtual void layout();
  FXTopWindow(FXApp* a,const FXString& name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs);
  FXTopWindow(FXWindow* owner,const FXString& name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs);
private:
  FXTopWindow(const FXTopWindow&);
  FXTopWindow& operator=(const FXTopWindow&);
public:
  virtual void create();
  virtual void detach();
  virtual void show();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual void move(FXint x,FXint y);
  virtual void resize(FXint w,FXint h);
  virtual void position(FXint x,FXint y,FXint w,FXint h);
  void setTitle(const FXString& name);
  FXString getTitle() const { return title; }
  FXint getHSpacing() const { return hspacing; }
  FXint getVSpacing() const { return vspacing; }
  void setHSpacing(FXint hs);
  void setVSpacing(FXint vs);
  void setPackingHints(FXuint ph);
  FXuint getPackingHints() const;
  void setDecorations(FXuint decorations);
  FXuint getDecorations() const;
  FXIcon* getIcon() const { return icon; }
  void setIcon(FXIcon* ic);
  FXIcon* getMiniIcon() const { return miniIcon; }
  void setMiniIcon(FXIcon *ic);
  virtual ~FXTopWindow();
  };


#endif
