/********************************************************************************
*                                                                               *
*                        M e n u   B u t t o n   W i d g e t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuButton.h,v 1.3 1999/09/28 12:56:11 jeroen Exp $                   *
********************************************************************************/
#ifndef FXMENUBUTTON_H
#define FXMENUBUTTON_H

class FXPopup;


// Menu button options
enum FXMenuButtonStyle {
  MENUBUTTON_AUTOGRAY      = 0x00800000,
  MENUBUTTON_AUTOHIDE      = 0x01000000,
  MENUBUTTON_TOOLBAR       = 0x02000000,
  MENUBUTTON_DOWN          = 0,
  MENUBUTTON_UP            = 0x04000000,
  MENUBUTTON_LEFT          = 0x08000000,
  MENUBUTTON_RIGHT         = MENUBUTTON_LEFT|MENUBUTTON_UP,
  MENUBUTTON_NOARROWS      = 0x10000000,
  MENUBUTTON_ATTACH_LEFT   = 0,
  MENUBUTTON_ATTACH_TOP    = MENUBUTTON_ATTACH_LEFT,
  MENUBUTTON_ATTACH_RIGHT  = 0x20000000,
  MENUBUTTON_ATTACH_BOTTOM = MENUBUTTON_ATTACH_RIGHT,
  MENUBUTTON_ATTACH_CENTER = 0x40000000,
  MENUBUTTON_ATTACH_BOTH   = MENUBUTTON_ATTACH_CENTER|MENUBUTTON_ATTACH_RIGHT 
  };
  
  

// Menu button
class FXAPI FXMenuButton : public FXLabel {
  FXDECLARE(FXMenuButton)
protected:
  FXPopup *pane;                  // Pane to pop up
  FXint    offsetx;               // Shift attachment point x
  FXint    offsety;               // Shift attachment point y
  FXbool   state;                 // Pane was popped
  FXString tip;                   // Tooltip text
  FXString help;                  // Help text
protected:
  FXMenuButton();
private:
  FXMenuButton(const FXMenuButton&);
  FXMenuButton &operator=(const FXMenuButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onCmdPost(FXObject*,FXSelector,void*);
  long onCmdUnpost(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
public:
  FXMenuButton(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXPopup* pup=NULL,FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool canFocus() const;
  virtual void killFocus();
  virtual FXbool contains(FXint parentx,FXint parenty) const;
  void setMenu(FXPopup *pup){ pane = pup; }
  FXPopup* getMenu() const { return pane; }
  void setXOffset(FXint offx){ offsetx=offx; }
  FXint getXOffset() const { return offsetx; }
  void setYOffset(FXint offy){ offsety=offy; }
  FXint getYOffset() const { return offsety; }
  void setButtonStyle(FXuint style);
  FXuint getButtonStyle() const;
  void setPopupStyle(FXuint style);
  FXuint getPopupStyle() const;
  void setAttachment(FXuint att);
  FXuint getAttachment() const;
  void setHelpText(const FXString&  text);
  FXString getHelpText() const { return help; }
  void setTipText(const FXString&  text);
  FXString getTipText() const { return tip; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXMenuButton();
  };

#endif
