/********************************************************************************
*                                                                               *
*                           O p e n G L   O b j e c t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLObject.h,v 1.3 1999/09/24 18:59:40 jeroen Exp $                      *
********************************************************************************/
#ifndef FXGLOBJECT_H
#define FXGLOBJECT_H


class FXGLViewer;

class FXGLObject;


// List of objects
typedef FXObjectListOf<FXGLObject> FXGLObjectList;


// Basic OpenGL object
class FXAPI FXGLObject : public FXObject {
  FXDECLARE(FXGLObject)
public:
  enum{
    ID_LAST=FXGLViewer::ID_LAST
    };
public:
  FXGLObject();
  virtual void bounds(FXRange& box);
  virtual void draw(FXGLViewer* viewer);
  virtual void hit(FXGLViewer* viewer);
  virtual FXGLObject* identify(FXuint* path);
  virtual FXbool canDrag() const;
  virtual FXbool canDelete() const;
  virtual FXbool drag(FXGLViewer* viewer,FXint fx,FXint fy,FXint tx,FXint ty);
  virtual ~FXGLObject();
  };


// Suppress warning about FXGLGroup::list not being exported
#ifdef _MSC_VER
#if _MSC_VER >= 1200
#pragma warning( push )
#endif
#pragma warning( disable : 4251 )
#endif
 

// Group object
class FXAPI FXGLGroup : public FXGLObject {
  FXDECLARE(FXGLGroup)
protected:
  FXGLObjectList  list;       // List of all objects
  FXint           current;    // Current object (-1 if no current object)
public:
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
public:
  FXGLGroup();
  FXGLObjectList& getList(){ return list; }
  FXint getCurrent() const { return current; }
  void setCurrent(FXint cur=-1){ current=cur; }
  virtual void bounds(FXRange& box);
  virtual void draw(FXGLViewer* viewer);
  virtual void hit(FXGLViewer* viewer);
  virtual FXGLObject* identify(FXuint* path);
  virtual FXbool canDrag() const;
  virtual FXbool drag(FXGLViewer* viewer,FXint fx,FXint fy,FXint tx,FXint ty);
  FXuint no() const { return list.no(); }
  FXGLObject* const& childAt(FXuint i) const { return list[i]; }
  FXGLObject*& childAt(FXuint i){ return list[i]; }
  void insert(FXuint pos,FXGLObject* obj){ list.insert(pos,obj); }
  void append(FXGLObject* obj){ list.append(obj); }
  void remove(FXGLObject* obj){ list.remove(obj); }
  void remove(FXuint pos){ list.remove(pos); }
  void clear(){ list.clear(); }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXGLGroup();
  };

  
// Restore previous warning levels
#ifdef _MSC_VER
#if _MSC_VER >= 1200
#pragma warning( pop )
#endif
#endif


// Test
class FXAPI FXGLPoint : public FXGLObject {
  FXDECLARE(FXGLPoint)
public:
  FXVec  pos;
public:
  FXGLPoint();
  FXGLPoint(FXfloat x,FXfloat y,FXfloat z);
  virtual void bounds(FXRange& box);
  virtual void draw(FXGLViewer* viewer);
  virtual void hit(FXGLViewer* viewer);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };

  
class FXAPI FXGLLine : public FXGLObject {
  FXDECLARE(FXGLLine)
public:
  FXGLPoint fm,to;
public:
  FXGLLine();
  FXGLLine(FXfloat fx,FXfloat fy,FXfloat fz,FXfloat tx,FXfloat ty,FXfloat tz);
  virtual void bounds(FXRange& box);
  virtual void draw(FXGLViewer* viewer);
  virtual void hit(FXGLViewer* viewer);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };
  
  
#endif

