/********************************************************************************
*                                                                               *
*                       C o m p o s i t e   W i d g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXComposite.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                     *
********************************************************************************/
#ifndef FXCOMPOSITE_H
#define FXCOMPOSITE_H



// Base composite
class FXAPI FXComposite : public FXWindow {
  FXDECLARE(FXComposite)
  friend class FXWindow;
protected:
  FXComposite(){}
  FXComposite(FXApp* a,FXVisual *vis);
  FXComposite(FXApp* a,FXWindow* own,FXuint opts,FXint x,FXint y,FXint w,FXint h);
  virtual void layout();
private:
  FXComposite(const FXComposite&);
  FXComposite &operator=(const FXComposite&);
public:
  long onFocusNext(FXObject*,FXSelector,void*);
  long onFocusPrev(FXObject*,FXSelector,void*);
  long onCmdUpdate(FXObject*,FXSelector,void*);
public:
  FXComposite(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool isComposite() const;
  virtual ~FXComposite();
  };

  
#endif
