""" Demonstration of how to nest modal Dialog megawidgets.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create button to launch the dialog.
	w = Tkinter.Button(parent, text = 'Show first dialog',
	        command = self.showFirstDialog)
	w.pack(padx = 8, pady = 8)

        self.timerId = None

	self.dialog2 = Pmw.Dialog(
		title = 'Dialog 2',
		buttons = ('Cancel',),
		deactivatecommand = self.cancelTimer,
		defaultbutton = 'Cancel')
	self.dialog2.withdraw()
	w = Tkinter.Label(self.dialog2.interior(),
	    text = 'This is the second modal dialog.\n' +
		'It will automatically disappear shortly')
	w.pack(padx = 10, pady = 10)

    def showFirstDialog(self):
	self.dialog1 = Pmw.MessageDialog(
		message_text = 'This is the first modal dialog.\n' +
			'You can see how dialogs nest by\n' +
			'clicking on the "Next" button.',
		title = 'Dialog 1',
		buttons = ('Next', 'Cancel'),
		defaultbutton = 'Next',
		command = self.next_dialog)
	self.dialog1.activate()
	self.dialog1.destroy()

    def cancelTimer(self):
        if self.timerId is not None:
            self.dialog2.after_cancel(self.timerId)
            self.timerId = None

    def deactivateSecond(self):
        self.timerId = None
	self.dialog2.deactivate()

    def next_dialog(self, result):
	if result != 'Next':
	    self.dialog1.deactivate()
	    return

	self.timerId = self.dialog2.after(3000, self.deactivateSecond)
	self.dialog2.activate()

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Modal dialog nesting demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
