#include "Typesmodule.h"

static PortableServer_ServantBase__epv base_epv = {
    NULL,
    NULL,
    NULL
};

/* Begin POA_Tester object */

statichere POA_Types_Tester__epv Types_Tester_epv = {
    NULL,
    Tester_impl_test_boolean,
    Tester_impl_test_short,
    Tester_impl_test_long,
    Tester_impl_test_float,
    Tester_impl_test_double,
    Tester_impl_test_string,
    Tester_impl_test_callback,
    Tester_impl_test_factory,
    Tester_impl_test_struct
};

statichere POA_Types_Tester__vepv Types_Tester_vepv = {
    &base_epv,
    &Types_Tester_epv
};

statichere POA_TesterObject *
wrapPOA_Tester(
    PyObject *object
) {
    POA_TesterObject *self;
    self = PyObject_NEW(POA_TesterObject, &POA_Tester_Type);
    if (self == NULL) return NULL;
    if (object == NULL) return NULL;
    self->impl.servant._private = NULL;
    self->impl.servant.vepv = &Types_Tester_vepv;
    self->impl.ob = object;
    Py_INCREF(object);
    Py_INCREF(self);
    return self;
}

static void
POA_Tester_dealloc(
    POA_TesterObject *self
) {
    CORBA_Environment ev;
    CORBA_exception_init(&ev);
    POA_Types_Tester__fini(&(self->impl.servant), &ev);
    PyMem_DEL(self);
}

statichere PyTypeObject POA_Tester_Type = {
    PyObject_HEAD_INIT(NULL)
    0,
    "POA_Types_Tester",
    sizeof(POA_TesterObject),
    0,
    (destructor)POA_Tester_dealloc,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

statichere CORBA_boolean
Tester_impl_test_boolean(
    PortableServer_Servant servant,
    const CORBA_boolean arg,
    CORBA_Environment *ev
) {
    CORBA_boolean retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_boolean",
        "(l)", (long) arg);
    retval = (CORBA_boolean) PyInt_AsLong(result);
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_short
Tester_impl_test_short(
    PortableServer_Servant servant,
    const CORBA_short arg,
    CORBA_Environment *ev
) {
    CORBA_short retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_short",
        "(l)", (long) arg);
    retval = (CORBA_short) PyInt_AsLong(result);
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_long
Tester_impl_test_long(
    PortableServer_Servant servant,
    const CORBA_long arg,
    CORBA_Environment *ev
) {
    CORBA_long retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_long",
        "(l)", (long) arg);
    retval = (CORBA_long) PyInt_AsLong(result);
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_float
Tester_impl_test_float(
    PortableServer_Servant servant,
    const CORBA_float arg,
    CORBA_Environment *ev
) {
    CORBA_float retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_float",
        "(d)", (double) arg);
    retval = (CORBA_float) PyFloat_AsDouble(result);
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_double
Tester_impl_test_double(
    PortableServer_Servant servant,
    const CORBA_double arg,
    CORBA_Environment *ev
) {
    CORBA_double retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_double",
        "(d)", (double) arg);
    retval = (CORBA_double) PyFloat_AsDouble(result);
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_char *
Tester_impl_test_string(
    PortableServer_Servant servant,
    const CORBA_char * arg,
    CORBA_Environment *ev
) {
    CORBA_char * retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_string",
        "(s)", (char *) arg);
    retval = (CORBA_char *) CORBA_string_dup(PyString_AsString(result));
    Py_XDECREF(result);
    return (retval);
}

statichere CORBA_boolean
Tester_impl_test_callback(
    PortableServer_Servant servant,
    const Types_Tester arg,
    CORBA_Environment *ev
) {
    CORBA_boolean retval;
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_callback",
        "(N)", (PyObject *) Tester2Object(arg));
    retval = (CORBA_boolean) PyInt_AsLong(result);
    Py_XDECREF(result);
    return (retval);
}

statichere Types_Tester
Tester_impl_test_factory(
    PortableServer_Servant servant,
    CORBA_Environment *ev
) {
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_factory",
        NULL);
    if (result == NULL) {
        PyErr_Print();
        return NULL;
    } else {
        return ((TesterObject*) result)->ob;
        Py_DECREF(result);
    }
}

statichere Types_Truth *
Tester_impl_test_struct(
    PortableServer_Servant servant,
    const Types_Truth *arg,
    CORBA_Environment *ev
) {
    PyObject *result=NULL;
    result = PyObject_CallMethod(
        ((impl_POA_Types_Tester*)servant)->ob, "test_struct",
        "(N)", (PyObject *) Truth2Object(arg));
    if (result == NULL) {
        PyErr_Print();
        return NULL;
    } else {
	return ((TruthObject*) result)->ob;
        Py_DECREF(result);
    }
}

/* End POA_Tester object */

/* Begin Tester object */

statichere TesterObject *
Tester2Object(
    Types_Tester object
) {
    TesterObject *self;
    if (object == NULL) return NULL;
    self = PyObject_NEW(TesterObject, &Tester_Type);
    if (self == NULL) return NULL;
    CORBA_exception_init(&(self->ev));
    self->ob = object;
    return self;
}

static void
Tester_dealloc(
    TesterObject *self
) {
    PyMem_DEL(self);
}

statichere PyObject *
Tester_test_boolean(
    TesterObject *self,
    PyObject *args
) {
    CORBA_boolean retval;
    long arg;
    if (!PyArg_ParseTuple(args, "l", &arg))
        return NULL;
    retval = Types_Tester_test_boolean(
        self->ob, (CORBA_boolean) arg, &(self->ev));
    checkCORBA(self->ev);
    if (retval) {
        Py_INCREF(Py_True);
        return (Py_True);
    } else {
        Py_INCREF(Py_False);
        return (Py_False);
    }
}

statichere PyObject *
Tester_test_short(
    TesterObject *self,
    PyObject *args
) {
    CORBA_short retval;
    long arg;
    if (!PyArg_ParseTuple(args, "l", &arg))
        return NULL;
    retval = Types_Tester_test_short(
        self->ob, (CORBA_short) arg, &(self->ev));
    checkCORBA(self->ev);
    return (Py_BuildValue("l", (long) retval));
}

statichere PyObject *
Tester_test_long(
    TesterObject *self,
    PyObject *args
) {
    CORBA_long retval;
    long arg;
    if (!PyArg_ParseTuple(args, "l", &arg))
        return NULL;
    retval = Types_Tester_test_long(
        self->ob, (CORBA_long) arg, &(self->ev));
    checkCORBA(self->ev);
    return (Py_BuildValue("l", (long) retval));
}

statichere PyObject *
Tester_test_float(
    TesterObject *self,
    PyObject *args
) {
    CORBA_float retval;
    double arg;
    if (!PyArg_ParseTuple(args, "d", &arg))
        return NULL;
    retval = Types_Tester_test_float(
        self->ob, (CORBA_float) arg, &(self->ev));
    checkCORBA(self->ev);
    return (Py_BuildValue("d", (double) retval));
}

statichere PyObject *
Tester_test_double(
    TesterObject *self,
    PyObject *args
) {
    CORBA_double retval;
    double arg;
    if (!PyArg_ParseTuple(args, "d", &arg))
        return NULL;
    retval = Types_Tester_test_double(
        self->ob, (CORBA_double) arg, &(self->ev));
    checkCORBA(self->ev);
    return (Py_BuildValue("d", (double) retval));
}

statichere PyObject *
Tester_test_string(
    TesterObject *self,
    PyObject *args
) {
    CORBA_char * retval;
    char *arg;
    if (!PyArg_ParseTuple(args, "s", &arg))
        return NULL;
    retval = Types_Tester_test_string(
        self->ob, (CORBA_char *) arg, &(self->ev));
    checkCORBA(self->ev);
    return (Py_BuildValue("s", (char *) retval));
}

statichere PyObject *
Tester_test_callback(
    TesterObject *self,
    PyObject *args
) {
    CORBA_boolean retval;
    PyObject *arg;
    if (!PyArg_ParseTuple(args, "O", &arg))
        return NULL;
    retval = Types_Tester_test_callback(
        self->ob, ((TesterObject *) arg)->ob, &(self->ev));
    checkCORBA(self->ev);
    if (retval) {
        Py_INCREF(Py_True);
        return (Py_True);
    } else {
        Py_INCREF(Py_False);
        return (Py_False);
    }
}

statichere PyObject *
Tester_test_factory(
    TesterObject *self,
    PyObject *args
) {
    Types_Tester retval;
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    retval = Types_Tester_test_factory(
        self->ob, &(self->ev));
    checkCORBA(self->ev);
    return (PyObject *) Tester2Object(retval);
}

statichere PyObject *
Tester_test_struct(
    TesterObject *self,
    PyObject *args
) {
    Types_Truth * retval;
    PyObject *arg;
    if (!PyArg_ParseTuple(args, "O", &arg))
        return NULL;
    retval = Types_Tester_test_struct(
        self->ob, ((TruthObject *) arg)->ob, &(self->ev));
    checkCORBA(self->ev);
    return (PyObject *) Truth2Object(retval);
}

statichere PyMethodDef Tester_methods[] = {
    {"test_boolean",	(PyCFunction)Tester_test_boolean,	1 },
    {"test_short",	(PyCFunction)Tester_test_short,	1 },
    {"test_long",	(PyCFunction)Tester_test_long,	1 },
    {"test_float",	(PyCFunction)Tester_test_float,	1 },
    {"test_double",	(PyCFunction)Tester_test_double,	1 },
    {"test_string",	(PyCFunction)Tester_test_string,	1 },
    {"test_callback",	(PyCFunction)Tester_test_callback,	1 },
    {"test_factory",	(PyCFunction)Tester_test_factory,	1 },
    {"test_struct",	(PyCFunction)Tester_test_struct,	1 },
    {NULL,	NULL}
};

static PyObject *
Tester_getattr(
    TesterObject *self,
    char *name
) {
    /* do attribute mapping (get__attr()) here */
    return Py_FindMethod(Tester_methods, (PyObject *) self, name);
}

static int
Tester_setattr(
    TesterObject *self,
    char *name,
    PyObject *v
) {
    /* do attribute mapping (set__attr()) here */
    return -1;
}

statichere PyTypeObject Tester_Type = {
    PyObject_HEAD_INIT(NULL)
    0,
    "Types_Tester",
    sizeof(TesterObject),
    0,
    (destructor)Tester_dealloc,
    0,
    (getattrfunc)Tester_getattr,
    (setattrfunc)Tester_setattr,
    0,
    0,
    0,
    0,
    0,
    0,
};

/* End Tester object */

PyObject *
POA_Tester(
    PyObject *self,
    PyObject *args
) {
    PyObject *object;
    CORBA_Environment ev;
    POA_TesterObject *retval;
    if (!PyArg_ParseTuple(args, "O", &object))
        return NULL;
    retval = wrapPOA_Tester(object);
    CORBA_exception_init(&ev);
    POA_Types_Tester__init(((POA_Types_Tester*) &(retval->impl)), &ev);
    return ((PyObject *) retval);
}

/* Begin Truth wrapper */

statichere TruthObject *
Truth2Object(
    Types_Truth * object
) {
    TruthObject *self;
    if (object == NULL) return NULL;
    self = PyObject_NEW(TruthObject, &Truth_Type);
    if (self == NULL) return NULL;
    CORBA_exception_init(&(self->ev));
    self->ob = object;
    return self;
}

static void
Truth_dealloc(
    TruthObject *self
) {
    PyMem_DEL(self);
}

static PyObject *
Truth_getattr(
    TruthObject *self,
    char *name
) {
    /* do attribute mapping (get__attr()) here */
}

static int
Truth_setattr(
    TruthObject *self,
    char *name,
    PyObject *v
) {
    /* do attribute mapping (set__attr()) here */
    return -1;
}

statichere PyTypeObject Truth_Type = {
    PyObject_HEAD_INIT(NULL)
    0,
    "Types_Tester",
    sizeof(TruthObject),
    0,
    (destructor)Truth_dealloc,
    0,
    (getattrfunc)Truth_getattr,
    (setattrfunc)Truth_setattr,
    0,
    0,
    0,
    0,
    0,
    0,
};

/* End Truth wrapper */

#if 0 /* not working (and not important, as far as I can tell) -JB */

/* Begin MyTest wrapper */

statichere MyTestObject *
MyTest2Object(
    Types_MyTest *struct
) {
    MyTestObject *self;
    if (struct == NULL) return NULL;
    self = PyObject_NEW(MyTestObject, &MyTest_Type);
    if (self == NULL) return NULL;
    self->struct = struct;
    return self;
}

static void
MyTest_dealloc(
    MyTestObject *self
) {
    PyMem_DEL(self);
}

static PyObject *
MyTest_getattr(
    MyTestObject *self,
    char *name
) {
    /* do attribute mapping (get__attr()) here */
}

static int
MyTest_setattr(
    MyTestObject *self,
    char *name,
    PyObject *v
) {
    /* do attribute mapping (set__attr()) here */
    return -1;
}

statichere PyTypeObject MyTest_Type = {
    PyObject_HEAD_INIT(NULL)
    0,
    "Types_Tester",
    sizeof(MyTestObject),
    0,
    (destructor)MyTest_dealloc,
    0,
    (getattrfunc)MyTest_getattr,
    (setattrfunc)MyTest_setattr,
    0,
    0,
    0,
    0,
    0,
    0,
};

/* End MyTest wrapper */

#endif

static PyMethodDef Types_methods[] = {
    {"POA_Tester",	POA_Tester,	1 },
    {NULL,	NULL}
};

#ifndef DL_EXPORT
#define DL_EXPORT(x) x
#endif

DL_EXPORT(void)
initTypes()
{
    PyObject *module, *dict;
    PyObject *CORBAmodule, *CORBAdict;
    POA_Tester_Type.ob_type = &PyType_Type;
    Tester_Type.ob_type = &PyType_Type;
    module = Py_InitModule("Types", Types_methods);
    dict = PyModule_GetDict(module);
    CORBAmodule = PyImport_ImportModule("CORBA");
    if (CORBAmodule != NULL) {
	CORBAdict = PyModule_GetDict(CORBAmodule);
	PyDict_SetItemString(CORBAdict,
			     TC_Types_Tester_struct.repo_id,
			     (PyObject *) &Tester_Type);
    } else {
      fprintf(stderr, "Could not import CORBA.\n");
    }
}

